/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.svggen;

import io.sf.carte.echosvg.ext.awt.g2d.GraphicContext;
import io.sf.carte.echosvg.svggen.AbstractSVGGradient;
import io.sf.carte.echosvg.svggen.SVGDescriptor;
import io.sf.carte.echosvg.svggen.SVGGeneratorContext;
import io.sf.carte.echosvg.svggen.SVGPaintDescriptor;
import java.awt.LinearGradientPaint;
import java.awt.Paint;
import java.awt.geom.Point2D;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SVGLinearGradient
extends AbstractSVGGradient {
    public SVGLinearGradient(SVGGeneratorContext generatorContext) {
        super(generatorContext);
    }

    @Override
    public SVGDescriptor toSVG(GraphicContext gc) {
        Paint paint = gc.getPaint();
        return this.toSVG((LinearGradientPaint)paint);
    }

    public SVGPaintDescriptor toSVG(LinearGradientPaint gradient) {
        return (SVGPaintDescriptor)this.descMap.computeIfAbsent(gradient, g -> this.createSvgPaintDescriptor((LinearGradientPaint)g));
    }

    private SVGPaintDescriptor createSvgPaintDescriptor(LinearGradientPaint gradient) {
        Document domFactory = this.getGeneratorContext().getDOMFactory();
        Element gradientDef = domFactory.createElementNS("http://www.w3.org/2000/svg", "linearGradient");
        gradientDef.setAttribute("gradientUnits", "userSpaceOnUse");
        Point2D p1 = gradient.getStartPoint();
        Point2D p2 = gradient.getEndPoint();
        String id = this.getGeneratorContext().getIDGenerator().generateID("linearGradient");
        gradientDef.setAttribute("id", id);
        gradientDef.setAttribute("x1", this.doubleString(p1.getX()));
        gradientDef.setAttribute("y1", this.doubleString(p1.getY()));
        gradientDef.setAttribute("x2", this.doubleString(p2.getX()));
        gradientDef.setAttribute("y2", this.doubleString(p2.getY()));
        gradientDef.setAttribute("spreadMethod", SVGLinearGradient.getSpreadMethod(gradient));
        this.addGradientStops(gradient, gradientDef, domFactory);
        this.defSet.add(gradientDef);
        return new SVGPaintDescriptor("url(#" + id + ")", "1", gradientDef);
    }
}

