/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.svggen;

import io.sf.carte.echosvg.ext.awt.g2d.GraphicContext;
import io.sf.carte.echosvg.svggen.AbstractSVGGradient;
import io.sf.carte.echosvg.svggen.SVGDescriptor;
import io.sf.carte.echosvg.svggen.SVGGeneratorContext;
import io.sf.carte.echosvg.svggen.SVGPaintDescriptor;
import java.awt.RadialGradientPaint;
import java.awt.geom.Point2D;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SVGRadialGradient
extends AbstractSVGGradient {
    public SVGRadialGradient(SVGGeneratorContext generatorContext) {
        super(generatorContext);
    }

    @Override
    public SVGDescriptor toSVG(GraphicContext gc) {
        return this.toSVG((RadialGradientPaint)gc.getPaint());
    }

    public SVGPaintDescriptor toSVG(RadialGradientPaint gradient) {
        return (SVGPaintDescriptor)this.descMap.computeIfAbsent(gradient, g -> this.createSvgPaintDescriptor((RadialGradientPaint)g));
    }

    private SVGPaintDescriptor createSvgPaintDescriptor(RadialGradientPaint gradient) {
        Document domFactory = this.getGeneratorContext().getDOMFactory();
        Element gradientDef = domFactory.createElementNS("http://www.w3.org/2000/svg", "radialGradient");
        gradientDef.setAttribute("gradientUnits", "userSpaceOnUse");
        Point2D center = gradient.getCenterPoint();
        Point2D focus = gradient.getFocusPoint();
        String id = this.getGeneratorContext().getIDGenerator().generateID("radialGradient");
        gradientDef.setAttribute("id", id);
        gradientDef.setAttribute("cx", this.doubleString(center.getX()));
        gradientDef.setAttribute("cy", this.doubleString(center.getY()));
        gradientDef.setAttribute("fx", this.doubleString(focus.getX()));
        gradientDef.setAttribute("fy", this.doubleString(focus.getY()));
        gradientDef.setAttribute("r", this.doubleString(gradient.getRadius()));
        gradientDef.setAttribute("spreadMethod", SVGRadialGradient.getSpreadMethod(gradient));
        this.addGradientStops(gradient, gradientDef, domFactory);
        this.defSet.add(gradientDef);
        return new SVGPaintDescriptor("url(#" + id + ")", "1", gradientDef);
    }
}

