/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.svggen;

import io.sf.carte.echosvg.svggen.SVGGraphics2DRuntimeException;
import io.sf.carte.echosvg.util.SVGConstants;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class XmlWriter
implements SVGConstants {
    private static String EOL;
    private static final String TAG_END = "/>";
    private static final String TAG_START = "</";
    private static final char[] SPACES;
    private static final int SPACES_LEN;
    private final IndentWriter out;
    private final boolean escaped;

    public XmlWriter(IndentWriter writer, boolean escaped) {
        if (writer == null) {
            throw new SVGGraphics2DRuntimeException("Writer should not be null");
        }
        this.out = writer;
        this.escaped = escaped;
    }

    public XmlWriter(Writer writer, boolean escaped) {
        this.out = new IndentWriter(writer);
        this.escaped = escaped;
    }

    protected final IndentWriter getWriter() {
        return this.out;
    }

    protected boolean isEscaped() {
        return this.escaped;
    }

    protected void writeXml(Attr attr) throws IOException {
        String name = attr.getName();
        this.out.write(name);
        this.out.write("=\"");
        this.writeAttributeValue(attr);
        this.out.write(34);
    }

    protected void writeAttributeValue(Attr attr) throws IOException {
        int last;
        String value = attr.getValue();
        if (value == null) {
            return;
        }
        char[] data = value.toCharArray();
        int length = data.length;
        int start = 0;
        block6: for (last = 0; last < length; ++last) {
            char c = data[last];
            switch (c) {
                case '<': {
                    this.out.write(data, start, last - start);
                    start = last + 1;
                    this.out.write("&lt;");
                    continue block6;
                }
                case '>': {
                    this.out.write(data, start, last - start);
                    start = last + 1;
                    this.out.write("&gt;");
                    continue block6;
                }
                case '&': {
                    this.out.write(data, start, last - start);
                    start = last + 1;
                    this.out.write("&amp;");
                    continue block6;
                }
                case '\"': {
                    this.out.write(data, start, last - start);
                    start = last + 1;
                    this.out.write("&quot;");
                    continue block6;
                }
                default: {
                    if (!this.isEscaped() || c <= '\u007f') continue block6;
                    this.out.write(data, start, last - start);
                    String hex = "0000" + Integer.toHexString(c);
                    this.out.write("&#x" + hex.substring(hex.length() - 4) + ";");
                    start = last + 1;
                }
            }
        }
        this.out.write(data, start, last - start);
    }

    protected void writeXml(Comment comment) throws IOException {
        int last;
        String sdata = comment.getData();
        if (sdata == null || sdata.isEmpty()) {
            this.out.write("<!---->");
            return;
        }
        char[] data = sdata.toCharArray();
        this.out.write("<!--");
        boolean sawDash = false;
        int length = data.length;
        int start = 0;
        for (last = 0; last < length; ++last) {
            char c = data[last];
            if (c == '-') {
                if (sawDash) {
                    this.out.write(data, start, last - start);
                    start = last;
                    this.out.write(32);
                }
                sawDash = true;
                continue;
            }
            sawDash = false;
        }
        this.out.write(data, start, last - start);
        if (sawDash) {
            this.out.write(32);
        }
        this.out.write("-->");
    }

    protected void writeXml(Text text) throws IOException {
        this.writeXml(text, false);
    }

    private void writeXml(Text text, boolean trimWS) throws IOException {
        char c;
        int last;
        String sdata = text.getData();
        if (sdata == null || sdata.isEmpty()) {
            return;
        }
        char[] data = sdata.toCharArray();
        int length = data.length;
        int start = 0;
        if (trimWS) {
            block12: for (last = 0; last < length; ++last) {
                c = data[last];
                switch (c) {
                    case '\t': 
                    case '\n': 
                    case '\r': 
                    case ' ': {
                        continue block12;
                    }
                }
            }
            start = last;
        }
        block13: while (last < length) {
            c = data[last];
            switch (c) {
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    if (!trimWS) break;
                    int wsStart = last++;
                    block14: while (last < length) {
                        switch (data[last]) {
                            case '\t': 
                            case '\n': 
                            case '\r': 
                            case ' ': {
                                ++last;
                                continue block14;
                            }
                        }
                    }
                    if (last != length) continue block13;
                    this.out.write(data, start, wsStart - start);
                    return;
                }
                case '<': {
                    this.out.write(data, start, last - start);
                    start = last + 1;
                    this.out.write("&lt;");
                    break;
                }
                case '>': {
                    this.out.write(data, start, last - start);
                    start = last + 1;
                    this.out.write("&gt;");
                    break;
                }
                case '&': {
                    this.out.write(data, start, last - start);
                    start = last + 1;
                    this.out.write("&amp;");
                    break;
                }
                default: {
                    if (!this.isEscaped() || c <= '\u007f') break;
                    this.out.write(data, start, last - start);
                    String hex = "0000" + Integer.toHexString(c);
                    this.out.write("&#x" + hex.substring(hex.length() - 4) + ";");
                    start = last + 1;
                }
            }
            ++last;
        }
        this.out.write(data, start, last - start);
    }

    protected void writeXml(CDATASection cdataSection) throws IOException {
        String sdata = cdataSection.getData();
        if (sdata == null || sdata.isEmpty()) {
            this.out.write("<![CDATA[]]>");
            return;
        }
        char[] data = sdata.toCharArray();
        this.out.write("<![CDATA[");
        int length = data.length;
        int start = 0;
        int last = 0;
        while (last < length) {
            char c = data[last];
            if (c == ']' && last + 2 < data.length && data[last + 1] == ']' && data[last + 2] == '>') {
                this.out.write(data, start, last - start);
                start = last + 1;
                this.out.write("]]]]><![CDATA[>");
                continue;
            }
            ++last;
        }
        this.out.write(data, start, last - start);
        this.out.write("]]>");
    }

    protected void writeXml(Element element) throws IOException {
        boolean lastElem;
        this.out.write(TAG_START, 0, 1);
        this.out.write(element.getTagName());
        NamedNodeMap attributes = element.getAttributes();
        if (attributes != null) {
            int nAttr = attributes.getLength();
            for (int i = 0; i < nAttr; ++i) {
                Attr attr = (Attr)attributes.item(i);
                this.out.write(32);
                this.writeXml(attr);
            }
        }
        boolean bl = lastElem = element.getParentNode().getLastChild() == element;
        if (!element.hasChildNodes()) {
            if (lastElem) {
                this.out.setIndentLevel(this.out.getIndentLevel() - 2);
            }
            this.out.printIndent();
            this.out.write(TAG_END, 0, 2);
            return;
        }
        Node child = element.getFirstChild();
        this.out.printIndent();
        this.out.write(TAG_END, 1, 1);
        if (child.getNodeType() != 3 || element.getLastChild() != child) {
            this.out.setIndentLevel(this.out.getIndentLevel() + 2);
        }
        this.writeChildrenXml(element);
        this.out.write(TAG_START, 0, 2);
        this.out.write(element.getTagName());
        if (lastElem) {
            this.out.setIndentLevel(this.out.getIndentLevel() - 2);
        }
        this.out.printIndent();
        this.out.write(TAG_END, 1, 1);
    }

    protected void writeChildrenXml(Element element) throws IOException {
        for (Node child = element.getFirstChild(); child != null; child = child.getNextSibling()) {
            this.writeXml(child);
        }
    }

    protected void writeXmlHeader() throws IOException {
        String encoding = null;
        if (this.out.getProxied() instanceof OutputStreamWriter) {
            OutputStreamWriter osw = (OutputStreamWriter)this.out.getProxied();
            encoding = XmlWriter.java2std(osw.getEncoding());
        }
        XmlWriter.writeXmlHeader(this.out, encoding);
    }

    static void writeXmlHeader(Writer out, String encoding) throws IOException {
        out.write("<?xml version=\"1.0\"");
        if (encoding != null) {
            out.write(" encoding=\"");
            out.write(encoding);
            out.write(34);
        }
        out.write("?>");
        out.write(EOL);
    }

    protected void writeXml(DocumentType docType) throws IOException {
        XmlWriter.writeDocumentType(this.out, docType.getName(), docType.getPublicId(), docType.getSystemId());
    }

    static void writeDocumentType(Writer out, String name, String publicId, String systemId) throws IOException {
        out.write("<!DOCTYPE ");
        out.write(name);
        if (publicId != null) {
            out.write(" PUBLIC '");
            out.write(publicId);
            out.write(39);
            out.write(EOL);
            out.write("         ");
        }
        if (systemId != null) {
            out.write(" '");
            out.write(systemId);
            out.write(39);
        }
        out.write(62);
        out.write(EOL);
    }

    protected void writeXml(Document document) throws IOException {
        this.writeXmlHeader();
        NodeList childList = document.getChildNodes();
        this.writeXml(childList);
    }

    protected void writeXml(NodeList childList) throws IOException {
        int length = childList.getLength();
        if (length == 0) {
            return;
        }
        for (int i = 0; i < length; ++i) {
            Node child = childList.item(i);
            this.writeXml(child);
            this.out.write(EOL);
        }
    }

    static String java2std(String encodingName) {
        if (encodingName == null) {
            return null;
        }
        if (encodingName.startsWith("ISO8859_")) {
            return "ISO-8859-" + encodingName.substring(8);
        }
        if (encodingName.startsWith("8859_")) {
            return "ISO-8859-" + encodingName.substring(5);
        }
        if ("ASCII7".equalsIgnoreCase(encodingName) || "ASCII".equalsIgnoreCase(encodingName)) {
            return "US-ASCII";
        }
        if ("UTF8".equalsIgnoreCase(encodingName)) {
            return "UTF-8";
        }
        if (encodingName.startsWith("Unicode")) {
            return "UTF-16";
        }
        if ("SJIS".equalsIgnoreCase(encodingName)) {
            return "Shift_JIS";
        }
        if ("JIS".equalsIgnoreCase(encodingName)) {
            return "ISO-2022-JP";
        }
        if ("EUCJIS".equalsIgnoreCase(encodingName)) {
            return "EUC-JP";
        }
        return "UTF-8";
    }

    public void writeXml(Node node) throws IOException, SVGGraphics2DRuntimeException {
        switch (node.getNodeType()) {
            case 1: {
                this.writeXml((Element)node);
                break;
            }
            case 2: {
                this.writeXml((Attr)node);
                break;
            }
            case 3: {
                this.writeXml((Text)node);
                break;
            }
            case 8: {
                this.writeXml((Comment)node);
                break;
            }
            case 4: {
                this.writeXml((CDATASection)node);
                break;
            }
            case 9: {
                this.writeXml((Document)node);
                break;
            }
            case 11: {
                NodeList childList = node.getChildNodes();
                this.writeXml(childList);
                break;
            }
            default: {
                throw new SVGGraphics2DRuntimeException("Unable to write node of type " + node.getClass().getName());
            }
        }
    }

    static {
        String temp;
        SPACES = new char[]{' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' '};
        SPACES_LEN = SPACES.length;
        try {
            temp = System.getProperty("line.separator", "\n");
        }
        catch (SecurityException e) {
            temp = "\n";
        }
        EOL = temp;
    }

    public static class IndentWriter
    extends Writer {
        protected Writer proxied;
        protected int indentLevel;
        protected int column;

        public IndentWriter(Writer proxied) throws SVGGraphics2DRuntimeException {
            if (proxied == null) {
                throw new SVGGraphics2DRuntimeException("Writer should not be null");
            }
            this.proxied = proxied;
        }

        public void setIndentLevel(int indentLevel) {
            this.indentLevel = indentLevel;
        }

        public int getIndentLevel() {
            return this.indentLevel;
        }

        public void printIndent() throws IOException {
            this.proxied.write(EOL);
            for (int temp = this.indentLevel; temp > 0; temp -= SPACES_LEN) {
                if (temp > SPACES_LEN) {
                    this.proxied.write(SPACES, 0, SPACES_LEN);
                    continue;
                }
                this.proxied.write(SPACES, 0, temp);
                break;
            }
            this.column = this.indentLevel;
        }

        public Writer getProxied() {
            return this.proxied;
        }

        public int getColumn() {
            return this.column;
        }

        @Override
        public void write(int c) throws IOException {
            ++this.column;
            this.proxied.write(c);
        }

        @Override
        public void write(char[] cbuf) throws IOException {
            this.column += cbuf.length;
            this.proxied.write(cbuf);
        }

        @Override
        public void write(char[] cbuf, int off, int len) throws IOException {
            this.column += len;
            this.proxied.write(cbuf, off, len);
        }

        @Override
        public void write(String str) throws IOException {
            this.column += str.length();
            this.proxied.write(str);
        }

        @Override
        public void write(String str, int off, int len) throws IOException {
            this.column += len;
            this.proxied.write(str, off, len);
        }

        @Override
        public void flush() throws IOException {
            this.proxied.flush();
        }

        @Override
        public void close() throws IOException {
            this.column = -1;
            this.proxied.close();
        }
    }
}

