/*

   See the NOTICE file distributed with this work for additional
   information regarding copyright ownership.

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.

 */
package io.sf.carte.echosvg.svggen;

import java.awt.Rectangle;
import java.awt.image.BufferedImageOp;
import java.util.List;

import org.w3c.dom.Element;

/**
 * Defines the interface for classes that are able to convert a BufferedImageOp
 * filter.
 *
 * @author <a href="mailto:vincent.hardy@eng.sun.com">Vincent Hardy</a>
 * @author For later modifications, see Git history.
 * @version $Id$
 * @see io.sf.carte.echosvg.svggen.SVGFilterDescriptor
 */
public interface SVGFilterConverter extends SVGSyntax {

	/**
	 * Converts a Java 2D API BufferedImageOp into a set of attribute/value pairs
	 * and related definitions
	 *
	 * @param filter     BufferedImageOp filter to be converted
	 * @param filterRect Rectangle, in device space, that defines the area to which
	 *                   filtering applies. May be null, meaning that the area is
	 *                   undefined.
	 * @return descriptor of the attributes required to represent the input filter
	 * @see io.sf.carte.echosvg.svggen.SVGFilterDescriptor
	 */
	SVGFilterDescriptor toSVG(BufferedImageOp filter, Rectangle filterRect);

	/**
	 * @return set of definitions referenced by the attribute values created by the
	 *         implementation since its creation. The return value should never be
	 *         null. If no definition is needed, an empty set should be returned.
	 */
	List<Element> getDefinitionSet();

}
