/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.swing.svg;

import io.sf.carte.echosvg.bridge.BridgeContext;
import io.sf.carte.echosvg.bridge.BridgeException;
import io.sf.carte.echosvg.bridge.DynamicGVTBuilder;
import io.sf.carte.echosvg.bridge.GVTBuilder;
import io.sf.carte.echosvg.bridge.InterruptedBridgeException;
import io.sf.carte.echosvg.gvt.GraphicsNode;
import io.sf.carte.echosvg.swing.svg.GVTTreeBuilderEvent;
import io.sf.carte.echosvg.swing.svg.GVTTreeBuilderListener;
import io.sf.carte.echosvg.util.EventDispatcher;
import io.sf.carte.echosvg.util.HaltingThread;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.svg.SVGDocument;

public class GVTTreeBuilder
extends HaltingThread {
    protected SVGDocument svgDocument;
    protected BridgeContext bridgeContext;
    protected List<Object> listeners = Collections.synchronizedList(new LinkedList());
    protected Exception exception;
    static EventDispatcher.Dispatcher startedDispatcher = new EventDispatcher.Dispatcher(){

        public void dispatch(Object listener, Object event) {
            ((GVTTreeBuilderListener)listener).gvtBuildStarted((GVTTreeBuilderEvent)event);
        }
    };
    static EventDispatcher.Dispatcher completedDispatcher = new EventDispatcher.Dispatcher(){

        public void dispatch(Object listener, Object event) {
            ((GVTTreeBuilderListener)listener).gvtBuildCompleted((GVTTreeBuilderEvent)event);
        }
    };
    static EventDispatcher.Dispatcher cancelledDispatcher = new EventDispatcher.Dispatcher(){

        public void dispatch(Object listener, Object event) {
            ((GVTTreeBuilderListener)listener).gvtBuildCancelled((GVTTreeBuilderEvent)event);
        }
    };
    static EventDispatcher.Dispatcher failedDispatcher = new EventDispatcher.Dispatcher(){

        public void dispatch(Object listener, Object event) {
            ((GVTTreeBuilderListener)listener).gvtBuildFailed((GVTTreeBuilderEvent)event);
        }
    };

    public GVTTreeBuilder(SVGDocument doc, BridgeContext bc) {
        this.svgDocument = doc;
        this.bridgeContext = bc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        GVTTreeBuilderEvent ev = new GVTTreeBuilderEvent((Object)this, null);
        try {
            this.fireEvent(startedDispatcher, ev);
            if (this.isHalted()) {
                this.fireEvent(cancelledDispatcher, ev);
                return;
            }
            Object builder = null;
            builder = this.bridgeContext.isDynamic() ? new DynamicGVTBuilder() : new GVTBuilder();
            GraphicsNode gvtRoot = builder.build(this.bridgeContext, (Document)this.svgDocument);
            if (this.isHalted()) {
                this.fireEvent(cancelledDispatcher, ev);
                return;
            }
            ev = new GVTTreeBuilderEvent((Object)this, gvtRoot);
            this.fireEvent(completedDispatcher, ev);
        }
        catch (InterruptedBridgeException e) {
            this.fireEvent(cancelledDispatcher, ev);
        }
        catch (BridgeException e) {
            this.exception = e;
            ev = new GVTTreeBuilderEvent((Object)this, e.getGraphicsNode());
            this.fireEvent(failedDispatcher, ev);
        }
        catch (Exception e) {
            this.exception = e;
            this.fireEvent(failedDispatcher, ev);
        }
        catch (ThreadDeath td) {
            this.exception = new Exception(td.getMessage());
            this.fireEvent(failedDispatcher, ev);
            throw td;
        }
        catch (Throwable t) {
            t.printStackTrace();
            this.exception = new Exception(t.getMessage());
            this.fireEvent(failedDispatcher, ev);
        }
    }

    public Exception getException() {
        return this.exception;
    }

    public void addGVTTreeBuilderListener(GVTTreeBuilderListener l) {
        this.listeners.add(l);
    }

    public void removeGVTTreeBuilderListener(GVTTreeBuilderListener l) {
        this.listeners.remove(l);
    }

    public void fireEvent(EventDispatcher.Dispatcher dispatcher, Object event) {
        EventDispatcher.fireEvent((EventDispatcher.Dispatcher)dispatcher, this.listeners, (Object)event, (boolean)true);
    }
}

