/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.swing.svg;

import io.sf.carte.echosvg.bridge.DocumentLoader;
import io.sf.carte.echosvg.swing.svg.SVGDocumentLoaderEvent;
import io.sf.carte.echosvg.swing.svg.SVGDocumentLoaderListener;
import io.sf.carte.echosvg.util.EventDispatcher;
import io.sf.carte.echosvg.util.HaltingThread;
import java.io.InterruptedIOException;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.w3c.dom.svg.SVGDocument;

public class SVGDocumentLoader
extends HaltingThread {
    protected String url;
    protected DocumentLoader loader;
    protected Exception exception;
    protected List<Object> listeners = Collections.synchronizedList(new LinkedList());
    static EventDispatcher.Dispatcher startedDispatcher = new EventDispatcher.Dispatcher(){

        public void dispatch(Object listener, Object event) {
            ((SVGDocumentLoaderListener)listener).documentLoadingStarted((SVGDocumentLoaderEvent)event);
        }
    };
    static EventDispatcher.Dispatcher completedDispatcher = new EventDispatcher.Dispatcher(){

        public void dispatch(Object listener, Object event) {
            ((SVGDocumentLoaderListener)listener).documentLoadingCompleted((SVGDocumentLoaderEvent)event);
        }
    };
    static EventDispatcher.Dispatcher cancelledDispatcher = new EventDispatcher.Dispatcher(){

        public void dispatch(Object listener, Object event) {
            ((SVGDocumentLoaderListener)listener).documentLoadingCancelled((SVGDocumentLoaderEvent)event);
        }
    };
    static EventDispatcher.Dispatcher failedDispatcher = new EventDispatcher.Dispatcher(){

        public void dispatch(Object listener, Object event) {
            ((SVGDocumentLoaderListener)listener).documentLoadingFailed((SVGDocumentLoaderEvent)event);
        }
    };

    public SVGDocumentLoader(String u, DocumentLoader l) {
        this.url = u;
        this.loader = l;
    }

    public void run() {
        SVGDocumentLoaderEvent evt = new SVGDocumentLoaderEvent((Object)this, null);
        try {
            this.fireEvent(startedDispatcher, evt);
            if (this.isHalted()) {
                this.fireEvent(cancelledDispatcher, evt);
                return;
            }
            SVGDocument svgDocument = (SVGDocument)this.loader.loadDocument(this.url);
            if (this.isHalted()) {
                this.fireEvent(cancelledDispatcher, evt);
                return;
            }
            evt = new SVGDocumentLoaderEvent((Object)this, svgDocument);
            this.fireEvent(completedDispatcher, evt);
        }
        catch (InterruptedIOException e) {
            this.fireEvent(cancelledDispatcher, evt);
        }
        catch (Exception e) {
            this.exception = e;
            this.fireEvent(failedDispatcher, evt);
        }
        catch (ThreadDeath td) {
            this.exception = new Exception(td.getMessage());
            this.fireEvent(failedDispatcher, evt);
            throw td;
        }
        catch (Throwable t) {
            t.printStackTrace();
            this.exception = new Exception(t.getMessage());
            this.fireEvent(failedDispatcher, evt);
        }
    }

    public Exception getException() {
        return this.exception;
    }

    public void addSVGDocumentLoaderListener(SVGDocumentLoaderListener l) {
        this.listeners.add(l);
    }

    public void removeSVGDocumentLoaderListener(SVGDocumentLoaderListener l) {
        this.listeners.remove(l);
    }

    public void fireEvent(EventDispatcher.Dispatcher dispatcher, Object event) {
        EventDispatcher.fireEvent((EventDispatcher.Dispatcher)dispatcher, this.listeners, (Object)event, (boolean)true);
    }
}

