/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.swing.svg;

import io.sf.carte.echosvg.bridge.BridgeContext;
import io.sf.carte.echosvg.bridge.InterruptedBridgeException;
import io.sf.carte.echosvg.bridge.UpdateManager;
import io.sf.carte.echosvg.gvt.GraphicsNode;
import io.sf.carte.echosvg.swing.svg.SVGLoadEventDispatcherEvent;
import io.sf.carte.echosvg.swing.svg.SVGLoadEventDispatcherListener;
import io.sf.carte.echosvg.util.EventDispatcher;
import io.sf.carte.echosvg.util.HaltingThread;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.w3c.dom.svg.SVGDocument;

public class SVGLoadEventDispatcher
extends HaltingThread {
    protected SVGDocument svgDocument;
    protected GraphicsNode root;
    protected BridgeContext bridgeContext;
    protected UpdateManager updateManager;
    protected List<Object> listeners = Collections.synchronizedList(new LinkedList());
    protected Exception exception;
    static EventDispatcher.Dispatcher startedDispatcher = new EventDispatcher.Dispatcher(){

        public void dispatch(Object listener, Object event) {
            ((SVGLoadEventDispatcherListener)listener).svgLoadEventDispatchStarted((SVGLoadEventDispatcherEvent)event);
        }
    };
    static EventDispatcher.Dispatcher completedDispatcher = new EventDispatcher.Dispatcher(){

        public void dispatch(Object listener, Object event) {
            ((SVGLoadEventDispatcherListener)listener).svgLoadEventDispatchCompleted((SVGLoadEventDispatcherEvent)event);
        }
    };
    static EventDispatcher.Dispatcher cancelledDispatcher = new EventDispatcher.Dispatcher(){

        public void dispatch(Object listener, Object event) {
            ((SVGLoadEventDispatcherListener)listener).svgLoadEventDispatchCancelled((SVGLoadEventDispatcherEvent)event);
        }
    };
    static EventDispatcher.Dispatcher failedDispatcher = new EventDispatcher.Dispatcher(){

        public void dispatch(Object listener, Object event) {
            ((SVGLoadEventDispatcherListener)listener).svgLoadEventDispatchFailed((SVGLoadEventDispatcherEvent)event);
        }
    };

    public SVGLoadEventDispatcher(GraphicsNode gn, SVGDocument doc, BridgeContext bc, UpdateManager um) {
        this.svgDocument = doc;
        this.root = gn;
        this.bridgeContext = bc;
        this.updateManager = um;
    }

    public void run() {
        SVGLoadEventDispatcherEvent ev = new SVGLoadEventDispatcherEvent((Object)this, this.root);
        try {
            this.fireEvent(startedDispatcher, ev);
            if (this.isHalted()) {
                this.fireEvent(cancelledDispatcher, ev);
                return;
            }
            this.updateManager.dispatchSVGLoadEvent();
            if (this.isHalted()) {
                this.fireEvent(cancelledDispatcher, ev);
                return;
            }
            this.fireEvent(completedDispatcher, ev);
        }
        catch (InterruptedBridgeException | InterruptedException e) {
            this.fireEvent(cancelledDispatcher, ev);
        }
        catch (Exception e) {
            this.exception = e;
            this.fireEvent(failedDispatcher, ev);
        }
        catch (ThreadDeath td) {
            this.exception = new Exception(td.getMessage());
            this.fireEvent(failedDispatcher, ev);
            throw td;
        }
        catch (Throwable t) {
            t.printStackTrace();
            this.exception = new Exception(t.getMessage());
            this.fireEvent(failedDispatcher, ev);
        }
    }

    public UpdateManager getUpdateManager() {
        return this.updateManager;
    }

    public Exception getException() {
        return this.exception;
    }

    public void addSVGLoadEventDispatcherListener(SVGLoadEventDispatcherListener l) {
        this.listeners.add(l);
    }

    public void removeSVGLoadEventDispatcherListener(SVGLoadEventDispatcherListener l) {
        this.listeners.remove(l);
    }

    public void fireEvent(EventDispatcher.Dispatcher dispatcher, Object event) {
        EventDispatcher.fireEvent((EventDispatcher.Dispatcher)dispatcher, this.listeners, (Object)event, (boolean)true);
    }
}

