/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.test;

import io.sf.carte.echosvg.util.ParsedURL;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.net.URL;

public class ResourceLoader {
    private static final ResourceLoader singleton = ResourceLoader.createResourceLoader();

    private static ResourceLoader createResourceLoader() {
        ResourceLoader loader;
        try {
            Class<?> cl = Class.forName("io.sf.carte.echosvg.test.SMResourceLoader");
            Constructor<?> ctor = cl.getConstructor(new Class[0]);
            loader = (ResourceLoader)ctor.newInstance(new Object[0]);
        }
        catch (Exception e) {
            loader = new ResourceLoader();
        }
        return loader;
    }

    public static ResourceLoader getInstance() {
        return singleton;
    }

    public URL getResource(Class<?> cl, String resourceName) {
        return cl.getClassLoader().getResource(resourceName);
    }

    public InputStream openStream(ParsedURL purl) throws IOException {
        return purl.openStream();
    }

    public InputStream getResourceAsStream(Class<?> cl, String resourceName) {
        return cl.getResourceAsStream(resourceName);
    }
}

