/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.test.xml;

import io.sf.carte.doc.xml.dtd.DefaultEntityResolver;
import io.sf.carte.util.agent.AgentUtil;
import io.sf.jclf.text.TokenParser;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Objects;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XmlUtil {
    private XmlUtil() {
    }

    public static String xmlDiff(URL refURL, byte[] data, File candidateFile) throws IOException {
        DocumentBuilder builder;
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        try {
            dbf.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
        }
        catch (ParserConfigurationException e) {
            throw new IllegalStateException(e);
        }
        try {
            builder = dbf.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new IllegalStateException(e);
        }
        builder.setEntityResolver((EntityResolver)new DefaultEntityResolver());
        return XmlUtil.xmlDiff(refURL, data, candidateFile, builder);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String xmlDiff(URL refURL, byte[] data, File candidateFile, DocumentBuilder builder) throws IOException {
        BufferedReader refReader;
        try {
            refReader = XmlUtil.urlToReader(refURL);
        }
        catch (FileNotFoundException e) {
            XmlUtil.save(data, candidateFile);
            return e.getMessage();
        }
        catch (IOException e) {
            XmlUtil.save(data, candidateFile);
            throw e;
        }
        ByteArrayInputStream dataIS = new ByteArrayInputStream(data);
        InputStreamReader r = new InputStreamReader((InputStream)dataIS, StandardCharsets.UTF_8);
        BufferedReader dataReader = new BufferedReader(r);
        String refStr = "";
        String dataStr = "";
        int line = 0;
        int cn = 0;
        try {
            while (refStr != null && dataStr != null) {
                if (!refStr.equals(dataStr) && (cn = XmlUtil.lineDiff(refStr, dataStr)) != -1) {
                    break;
                }
                refStr = refReader.readLine();
                dataStr = dataReader.readLine();
                ++line;
            }
        }
        catch (IOException e) {
            XmlUtil.save(data, candidateFile);
            String string = "Error while comparing images: " + e.getMessage();
            return string;
        }
        finally {
            try {
                refReader.close();
            }
            catch (IOException iOException) {}
        }
        try {
            if (refStr == null && dataStr == null) {
                return null;
            }
            if (XmlUtil.compareDOM(refURL, data, builder)) {
                return null;
            }
            XmlUtil.save(data, candidateFile);
            String expectedChar = "<eol>";
            if (cn >= 0 && refStr != null && refStr.length() > cn) {
                expectedChar = refStr.substring(cn, cn + 1);
            }
            String foundChar = "<null>";
            if (cn >= 0 && dataStr != null && dataStr.length() > cn) {
                foundChar = dataStr.substring(cn, cn + 1);
            }
            if (expectedChar.equals(" ")) {
                expectedChar = "' '";
            }
            if (foundChar.equals(" ")) {
                foundChar = "' '";
            }
            return "Expected " + expectedChar + ", found " + foundChar + " at line/column " + line + '/' + (cn + 1) + ":\n" + refStr + '\n' + dataStr;
        }
        catch (Exception e) {
            XmlUtil.save(data, candidateFile);
            return "Error while comparing images: " + e.getMessage();
        }
    }

    private static BufferedReader urlToReader(URL refURL) throws IOException {
        Reader r;
        URLConnection urlc = refURL.openConnection();
        InputStream is = urlc.getInputStream();
        String conType = urlc.getContentType();
        String contentEncoding = urlc.getContentEncoding();
        try {
            r = AgentUtil.inputStreamToReader((InputStream)is, (String)conType, (String)contentEncoding, (Charset)StandardCharsets.UTF_8);
        }
        catch (FileNotFoundException e) {
            throw e;
        }
        catch (IOException e) {
            try {
                is.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw e;
        }
        return new BufferedReader(r);
    }

    public static int lineDiff(String refLine, String checkLine) {
        ArrayList<String> refTk = new ArrayList<String>();
        TokenParser st = new TokenParser(refLine, " ;{}", "\"", true);
        while (st.hasMoreTokens()) {
            String s = st.nextToken();
            refTk.add(s);
        }
        ArrayList<String> checkTk = new ArrayList<String>(refTk.size() + 2);
        st = new TokenParser(checkLine, " ;{}", "\"", true);
        while (st.hasMoreTokens()) {
            String s = st.nextToken();
            checkTk.add(s);
        }
        if (refTk.size() == checkTk.size()) {
            for (String s : refTk) {
                if (checkTk.contains(s)) continue;
                return XmlUtil.computeColumnNumber(refLine, checkLine, refLine.indexOf(s));
            }
            return -1;
        }
        return XmlUtil.computeColumnNumber(refLine, checkLine, 0);
    }

    private static int computeColumnNumber(String aStr, String bStr, int offset) {
        int i;
        if (aStr == null || bStr == null) {
            return -1;
        }
        int n = aStr.length();
        for (i = offset; i < n; ++i) {
            char b;
            char a = aStr.charAt(i);
            if (i >= bStr.length() || a != (b = bStr.charAt(i))) break;
        }
        return i;
    }

    private static boolean compareDOM(URL refURL, byte[] data, DocumentBuilder builder) throws IOException {
        Document newDoc;
        Document refDoc;
        String uri = refURL.toExternalForm();
        BufferedReader refReader = XmlUtil.urlToReader(refURL);
        InputSource source = new InputSource(refReader);
        source.setSystemId(uri);
        try {
            refDoc = builder.parse(source);
        }
        catch (SAXException e) {
            e.printStackTrace();
            return false;
        }
        ByteArrayInputStream newStream = new ByteArrayInputStream(data);
        InputStreamReader candReader = new InputStreamReader((InputStream)newStream, StandardCharsets.UTF_8);
        source = new InputSource(candReader);
        source.setSystemId(uri);
        try {
            newDoc = builder.parse(source);
        }
        catch (SAXException e) {
            e.printStackTrace();
            return false;
        }
        return XmlUtil.isEquivalentNode(refDoc, newDoc);
    }

    private static boolean isEquivalentNode(Node node, Node other) {
        if (other == null) {
            return false;
        }
        short nt = other.getNodeType();
        if (!(nt == node.getNodeType() && Objects.equals(node.getNodeName(), other.getNodeName()) && Objects.equals(node.getLocalName(), other.getLocalName()) && Objects.equals(node.getPrefix(), other.getPrefix()) && Objects.equals(node.getNodeValue(), other.getNodeValue()) && XmlUtil.compareNamedNodeMaps(node.getAttributes(), other.getAttributes()))) {
            return false;
        }
        if (nt == 10) {
            DocumentType dt1 = (DocumentType)node;
            DocumentType dt2 = (DocumentType)other;
            if (!(Objects.equals(dt1.getPublicId(), dt2.getPublicId()) && Objects.equals(dt1.getSystemId(), dt2.getSystemId()) && Objects.equals(dt1.getInternalSubset(), dt2.getInternalSubset()) && XmlUtil.compareNamedNodeMaps(dt1.getEntities(), dt2.getEntities()) && XmlUtil.compareNamedNodeMaps(dt1.getNotations(), dt2.getNotations()))) {
                return false;
            }
        }
        Node n = node.getFirstChild();
        Node m = other.getFirstChild();
        if (n != null ? !XmlUtil.isEquivalentNode(n, m) : m != null) {
            return false;
        }
        n = node.getNextSibling();
        m = other.getNextSibling();
        return !(n != null ? !XmlUtil.isEquivalentNode(n, m) : m != null);
    }

    private static boolean compareNamedNodeMaps(NamedNodeMap attributes, NamedNodeMap attributes2) {
        int nl2;
        if (attributes == null) {
            return attributes2 == null;
        }
        if (attributes2 == null) {
            return false;
        }
        int nl = attributes.getLength();
        if (nl != (nl2 = attributes2.getLength())) {
            return false;
        }
        for (int i = 0; i < nl; ++i) {
            Node attr = attributes.item(i);
            String localName = attr.getLocalName();
            Node attr2 = localName != null ? attributes2.getNamedItemNS(attr.getNamespaceURI(), localName) : attributes2.getNamedItem(attr.getNodeName());
            if (attr2 == null) {
                return false;
            }
            if (XmlUtil.isEquivalentNode(attr, attr2)) continue;
            return false;
        }
        return true;
    }

    private static void save(byte[] data, File candidateFile) throws IOException {
        if (candidateFile == null) {
            return;
        }
        File parentDir = candidateFile.getParentFile();
        if (!parentDir.exists() && !parentDir.mkdir()) {
            return;
        }
        try (FileOutputStream os = new FileOutputStream(candidateFile);){
            os.write(data);
        }
    }
}

