/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.test.image;

import io.sf.carte.echosvg.ext.awt.image.GraphicsUtil;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.color.ColorSpace;
import java.awt.color.ICC_ColorSpace;
import java.awt.color.ICC_Profile;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.WritableRaster;

public class ImageComparator {
    public static final short MATCH = 0;
    public static final short DIFFERENT_SIZES = 1;
    public static final short DIFFERENT_TRANSPARENCIES = 2;
    public static final short DIFFERENT_TYPES = 3;
    public static final short DIFFERENT_COLOR_SPACES = 4;
    public static final short DIFFERENT_BANDS = 5;
    public static final short DIFFERENT_DATA_TYPES = 6;
    public static final short DIFFERENT_PIXELS_BELOW_THRESHOLD = 10;
    public static final short DIFFERENT_PIXELS_OVER_THRESHOLD = 11;
    public static final short NO_VARIANTS = 20;
    public static final short VARIANT_ERROR = 21;
    private static final int diffPixelFactor = 10;
    private static int minDiffPixelsForNonzeroAllowance = 30;

    public static void setMinDiffPixelsForNonzeroAllowance(int minDiffPixelsForNonzeroAllowance) {
        if (minDiffPixelsForNonzeroAllowance < 0) {
            throw new IllegalArgumentException("Number of pixels must be at least 0.");
        }
        ImageComparator.minDiffPixelsForNonzeroAllowance = minDiffPixelsForNonzeroAllowance;
    }

    public static short compareImages(BufferedImage ref, BufferedImage can, int pixelThreshold, float allowedPercentBelowThreshold, float allowedPercentOverThreshold) {
        boolean canPre;
        int numBands;
        int w = ref.getWidth();
        int h = ref.getHeight();
        if (w != can.getWidth() || h != can.getHeight()) {
            return 1;
        }
        if (ref.getTransparency() != can.getTransparency()) {
            return 2;
        }
        if (ref.getType() != can.getType() && ref.getType() != 0 && can.getType() != 0) {
            return 3;
        }
        if (ref.getType() == 0) {
            ColorSpace refColorSpace = ref.getColorModel().getColorSpace();
            ColorSpace canColorSpace = can.getColorModel().getColorSpace();
            if (refColorSpace.getType() != canColorSpace.getType() || !ImageComparator.isSameColorSpace(refColorSpace, canColorSpace)) {
                return 4;
            }
        }
        if ((numBands = ref.getSampleModel().getNumBands()) != can.getSampleModel().getNumBands()) {
            return 5;
        }
        if (ref.getSampleModel().getDataType() != can.getSampleModel().getDataType()) {
            return 6;
        }
        float numpxFrac = (float)(w * h * numBands) / 100.0f;
        int maxDiffPx = ImageComparator.computeMaxDiffPixels(numpxFrac, allowedPercentOverThreshold, w, h);
        int maxDiffPxBelow = ImageComparator.computeMaxDiffPixels(numpxFrac, allowedPercentBelowThreshold, w, h);
        WritableRaster refWR = ref.getRaster();
        WritableRaster canWR = can.getRaster();
        boolean refPre = ref.isAlphaPremultiplied();
        if (!refPre) {
            ColorModel cm = ref.getColorModel();
            cm = GraphicsUtil.coerceData((WritableRaster)refWR, (ColorModel)cm, (boolean)true);
            ref = new BufferedImage(cm, refWR, true, null);
        }
        if (!(canPre = can.isAlphaPremultiplied())) {
            ColorModel cm = can.getColorModel();
            cm = GraphicsUtil.coerceData((WritableRaster)canWR, (ColorModel)cm, (boolean)true);
            can = new BufferedImage(cm, canWR, true, null);
        }
        int result = 0;
        int countDiffPx = 0;
        int countDiffPxBelow = 0;
        int[] refPix = null;
        int[] canPix = null;
        block0: for (int y = 0; y < h; ++y) {
            refPix = refWR.getPixels(0, y, w, 1, refPix);
            canPix = canWR.getPixels(0, y, w, 1, canPix);
            for (int i = 0; i < refPix.length; ++i) {
                int diff = canPix[i] - refPix[i];
                if (diff == 0) continue;
                if (Math.abs(diff) <= pixelThreshold) {
                    if (++countDiffPxBelow <= maxDiffPxBelow) continue;
                    result = 10;
                    break block0;
                }
                if (++countDiffPx <= maxDiffPx) continue;
                result = 11;
                break block0;
            }
        }
        if (!canPre) {
            ColorModel cm = can.getColorModel();
            cm = GraphicsUtil.coerceData((WritableRaster)canWR, (ColorModel)cm, (boolean)false);
        }
        if (!refPre) {
            ColorModel cm = ref.getColorModel();
            cm = GraphicsUtil.coerceData((WritableRaster)refWR, (ColorModel)cm, (boolean)false);
        }
        return (short)result;
    }

    private static boolean isSameColorSpace(ColorSpace refColorSpace, ColorSpace canColorSpace) {
        if (refColorSpace == canColorSpace) {
            return true;
        }
        if (!(refColorSpace instanceof ICC_ColorSpace) || !(canColorSpace instanceof ICC_ColorSpace)) {
            return false;
        }
        ICC_Profile refProfile = ((ICC_ColorSpace)refColorSpace).getProfile();
        ICC_Profile canProfile = ((ICC_ColorSpace)canColorSpace).getProfile();
        return refProfile.getProfileClass() == canProfile.getProfileClass() && refProfile.getMajorVersion() == canProfile.getMajorVersion() && refProfile.getMinorVersion() == canProfile.getMinorVersion() && Math.abs(refProfile.getData().length - canProfile.getData().length) <= 16;
    }

    private static int computeMaxDiffPixels(float numpxFrac, float allowedPercent, int width, int height) {
        int maxDiffPx;
        if (allowedPercent == 0.0f) {
            maxDiffPx = 0;
        } else {
            maxDiffPx = Math.round(numpxFrac * allowedPercent);
            if (maxDiffPx < minDiffPixelsForNonzeroAllowance && allowedPercent < 1.0f) {
                int minDiff = Math.min(width, height) - 1;
                if (maxDiffPx < (minDiff = Math.min(minDiff, minDiffPixelsForNonzeroAllowance))) {
                    maxDiffPx = minDiff;
                }
            }
        }
        return maxDiffPx;
    }

    public static short compareVariantImages(BufferedImage ref, BufferedImage can, int pixelThreshold, float allowedPercentBelowThreshold, float allowedPercentOverThreshold, ImageVariants variants) {
        boolean canPre;
        int w = ref.getWidth();
        int h = ref.getHeight();
        if (w != can.getWidth() || h != can.getHeight()) {
            return 1;
        }
        if (ref.getTransparency() != can.getTransparency()) {
            return 2;
        }
        if (ref.getType() != can.getType()) {
            return 3;
        }
        ColorSpace refCS = ref.getColorModel().getColorSpace();
        int colorSpace = refCS.getType();
        if (colorSpace != can.getColorModel().getColorSpace().getType()) {
            return 4;
        }
        int numBands = ref.getSampleModel().getNumBands();
        float numpxFrac = (float)(w * h * numBands) / 100.0f;
        int maxDiffPx = ImageComparator.computeMaxDiffPixels(numpxFrac, allowedPercentOverThreshold, w, h);
        int maxDiffPxBelow = ImageComparator.computeMaxDiffPixels(numpxFrac, allowedPercentBelowThreshold, w, h);
        WritableRaster refWR = ref.getRaster();
        WritableRaster canWR = can.getRaster();
        boolean refPre = ref.isAlphaPremultiplied();
        if (!refPre) {
            ColorModel cm = ref.getColorModel();
            cm = GraphicsUtil.coerceData((WritableRaster)refWR, (ColorModel)cm, (boolean)true);
            ref = new BufferedImage(cm, refWR, true, null);
        }
        if (!(canPre = can.isAlphaPremultiplied())) {
            ColorModel cm = can.getColorModel();
            cm = GraphicsUtil.coerceData((WritableRaster)canWR, (ColorModel)cm, (boolean)true);
            can = new BufferedImage(cm, canWR, true, null);
        }
        BufferedImage variant = variants.getVariantImage(0, refCS);
        int result = 20;
        if (variant != null) {
            if (w != variant.getWidth() || h != variant.getHeight()) {
                if (!canPre) {
                    GraphicsUtil.coerceData((WritableRaster)canWR, (ColorModel)can.getColorModel(), (boolean)false);
                }
                if (!refPre) {
                    GraphicsUtil.coerceData((WritableRaster)refWR, (ColorModel)ref.getColorModel(), (boolean)false);
                }
                return 21;
            }
            result = ImageComparator.rangeCompare(ref, canWR, variant);
        }
        if (result != 0) {
            int vCount = variants.getVariantCount();
            for (int i = 1; i < vCount; ++i) {
                variant = variants.getVariantImage(i, refCS);
                if (variant == null) continue;
                if (w != variant.getWidth() || h != variant.getHeight()) {
                    result = 21;
                    break;
                }
                result = ImageComparator.compareVariant(ref, canWR, variant, pixelThreshold, maxDiffPxBelow, maxDiffPx);
                if (result == 0) break;
            }
        }
        if (!canPre) {
            ColorModel cm = can.getColorModel();
            GraphicsUtil.coerceData((WritableRaster)canWR, (ColorModel)cm, (boolean)false);
        }
        if (!refPre) {
            ColorModel cm = ref.getColorModel();
            GraphicsUtil.coerceData((WritableRaster)refWR, (ColorModel)cm, (boolean)false);
        }
        return (short)result;
    }

    private static short rangeCompare(BufferedImage ref, WritableRaster genWR, BufferedImage variant) {
        int w = ref.getWidth();
        int h = ref.getHeight();
        WritableRaster refWR = ref.getRaster();
        WritableRaster varWR = variant.getRaster();
        int result = 0;
        int countDiffPx = 0;
        int maxDiffPx = Math.round((float)(w * h) * 1.0E-4f);
        int[] refPix = null;
        int[] genPix = null;
        int[] varPix = null;
        block0: for (int y = 0; y < h; ++y) {
            refPix = refWR.getPixels(0, y, w, 1, refPix);
            genPix = genWR.getPixels(0, y, w, 1, genPix);
            varPix = varWR.getPixels(0, y, w, 1, varPix);
            for (int i = 0; i < refPix.length; ++i) {
                int varPx;
                int diff = genPix[i] - refPix[i];
                if (diff == 0 || (varPx = varPix[i]) != 0 && Math.abs(diff) <= varPx + 1 || ++countDiffPx <= maxDiffPx) continue;
                result = 11;
                break block0;
            }
        }
        return (short)result;
    }

    private static short compareVariant(BufferedImage ref, WritableRaster genWR, BufferedImage variant, int pixelThreshold, int maxDiffPxBelow, int maxDiffPx) {
        int w = ref.getWidth();
        int h = ref.getHeight();
        WritableRaster refWR = ref.getRaster();
        WritableRaster varWR = variant.getRaster();
        int result = 0;
        int countDiffPx = 0;
        int countDiffPxBelow = 0;
        int[] refPix = null;
        int[] genPix = null;
        int[] varPix = null;
        block0: for (int y = 0; y < h; ++y) {
            refPix = refWR.getPixels(0, y, w, 1, refPix);
            genPix = genWR.getPixels(0, y, w, 1, genPix);
            varPix = varWR.getPixels(0, y, w, 1, varPix);
            for (int i = 0; i < refPix.length; ++i) {
                int varPx;
                int diff = genPix[i] - refPix[i];
                if (diff == 0 || ((varPx = varPix[i]) != 0 ? varPx == 255 && diff > 12 : diff < -12)) continue;
                int acceptDiff = Math.round((float)(varPx - 128) / 10.0f);
                if ((diff = Math.abs(diff - acceptDiff)) <= 1) continue;
                if (diff <= pixelThreshold) {
                    if (++countDiffPxBelow <= maxDiffPxBelow) continue;
                    result = 10;
                    break block0;
                }
                if (++countDiffPx <= maxDiffPx) continue;
                result = 11;
                break block0;
            }
        }
        return (short)result;
    }

    public static String getResultDescription(short code) {
        String desc;
        switch (code) {
            case 0: {
                desc = "Match";
                break;
            }
            case 1: {
                desc = "The images have different sizes";
                break;
            }
            case 2: {
                desc = "The images have different sizes";
                break;
            }
            case 3: {
                desc = "The images are of different types";
                break;
            }
            case 4: {
                desc = "The images have different color spaces";
                break;
            }
            case 5: {
                desc = "The images have a different number of bands";
                break;
            }
            case 6: {
                desc = "The images use different buffer data types";
                break;
            }
            case 10: {
                desc = "The images have too many below-threshold different pixels";
                break;
            }
            case 11: {
                desc = "The images have too many over-threshold different pixels";
                break;
            }
            case 20: {
                desc = "A variant comparison was executed but no variants were found";
                break;
            }
            case 21: {
                desc = "At least one of the image variants is wrong (wrong size, etc)";
                break;
            }
            default: {
                desc = "unknown code";
            }
        }
        return desc;
    }

    public static BufferedImage createCompareImage(BufferedImage ref, BufferedImage gen) {
        BufferedImage cmp = ImageComparator.createImageOfType(ref.getWidth() * 2, ref.getHeight(), ref);
        Graphics2D g = cmp.createGraphics();
        g.setPaint(Color.white);
        g.fillRect(0, 0, cmp.getWidth(), cmp.getHeight());
        g.drawImage((Image)ref, 0, 0, null);
        g.translate(ref.getWidth(), 0);
        g.drawImage((Image)gen, 0, 0, null);
        g.dispose();
        return cmp;
    }

    public static BufferedImage createDiffImage(BufferedImage ref, BufferedImage gen) {
        boolean genPre;
        int w = ref.getWidth();
        int h = ref.getHeight();
        BufferedImage diff = ImageComparator.createImageOfType(w, h, ref);
        WritableRaster refWR = ref.getRaster();
        WritableRaster genWR = gen.getRaster();
        WritableRaster dstWR = diff.getRaster();
        boolean refPre = ref.isAlphaPremultiplied();
        if (!refPre) {
            ColorModel cm = ref.getColorModel();
            cm = GraphicsUtil.coerceData((WritableRaster)refWR, (ColorModel)cm, (boolean)true);
            ref = new BufferedImage(cm, refWR, true, null);
        }
        if (!(genPre = gen.isAlphaPremultiplied())) {
            ColorModel cm = gen.getColorModel();
            cm = GraphicsUtil.coerceData((WritableRaster)genWR, (ColorModel)cm, (boolean)true);
            gen = new BufferedImage(cm, genWR, true, null);
        }
        int[] refPix = null;
        int[] genPix = null;
        for (int y = 0; y < h; ++y) {
            refPix = refWR.getPixels(0, y, w, 1, refPix);
            genPix = genWR.getPixels(0, y, w, 1, genPix);
            for (int i = 0; i < refPix.length; ++i) {
                int val = (genPix[i] - refPix[i]) * 10 + 128;
                if ((val & 0xFFFFFF00) != 0) {
                    val = (val & Integer.MIN_VALUE) != 0 ? 0 : 255;
                }
                genPix[i] = val;
            }
            dstWR.setPixels(0, y, w, 1, genPix);
        }
        if (!genPre) {
            ColorModel cm = gen.getColorModel();
            cm = GraphicsUtil.coerceData((WritableRaster)genWR, (ColorModel)cm, (boolean)false);
        }
        if (!refPre) {
            ColorModel cm = ref.getColorModel();
            cm = GraphicsUtil.coerceData((WritableRaster)refWR, (ColorModel)cm, (boolean)false);
        }
        return diff;
    }

    private static BufferedImage createImageOfType(int width, int height, BufferedImage ref) {
        BufferedImage image;
        int type = ref.getType();
        if (type != 0) {
            image = new BufferedImage(width, height, type);
        } else {
            ColorModel cm = ref.getColorModel();
            WritableRaster raster = cm.createCompatibleWritableRaster(width, height);
            image = new BufferedImage(cm, raster, false, null);
        }
        return image;
    }

    public static BufferedImage createExactDiffImage(BufferedImage ref, BufferedImage gen) {
        boolean genPre;
        int w = ref.getWidth();
        int h = ref.getHeight();
        if (w != gen.getWidth()) {
            throw new IllegalArgumentException("Ref. image has width " + w + " but generated image is " + gen.getWidth());
        }
        if (h != gen.getHeight()) {
            throw new IllegalArgumentException("Ref. image has height " + h + " but generated image is " + gen.getHeight());
        }
        BufferedImage diff = ImageComparator.createImageOfType(w, h, ref);
        WritableRaster refWR = ref.getRaster();
        WritableRaster genWR = gen.getRaster();
        WritableRaster dstWR = diff.getRaster();
        boolean refPre = ref.isAlphaPremultiplied();
        if (!refPre) {
            ColorModel cm = ref.getColorModel();
            cm = GraphicsUtil.coerceData((WritableRaster)refWR, (ColorModel)cm, (boolean)true);
            ref = new BufferedImage(cm, refWR, true, null);
        }
        if (!(genPre = gen.isAlphaPremultiplied())) {
            ColorModel cm = gen.getColorModel();
            cm = GraphicsUtil.coerceData((WritableRaster)genWR, (ColorModel)cm, (boolean)true);
            gen = new BufferedImage(cm, genWR, true, null);
        }
        int[] refPix = null;
        int[] genPix = null;
        for (int y = 0; y < h; ++y) {
            refPix = refWR.getPixels(0, y, w, 1, refPix);
            genPix = genWR.getPixels(0, y, w, 1, genPix);
            for (int i = 0; i < refPix.length; ++i) {
                int val;
                genPix[i] = val = Math.abs(genPix[i] - refPix[i]);
            }
            dstWR.setPixels(0, y, w, 1, genPix);
        }
        if (!genPre) {
            ColorModel cm = gen.getColorModel();
            cm = GraphicsUtil.coerceData((WritableRaster)genWR, (ColorModel)cm, (boolean)false);
        }
        if (!refPre) {
            ColorModel cm = ref.getColorModel();
            cm = GraphicsUtil.coerceData((WritableRaster)refWR, (ColorModel)cm, (boolean)false);
        }
        return diff;
    }

    public static BufferedImage createMergedDiffImage(BufferedImage ref, BufferedImage gen, BufferedImage rangeDiff) {
        boolean genPre;
        int w = ref.getWidth();
        int h = ref.getHeight();
        BufferedImage diff = ImageComparator.createImageOfType(w, h, ref);
        WritableRaster refWR = ref.getRaster();
        WritableRaster genWR = gen.getRaster();
        WritableRaster rangeWR = rangeDiff.getRaster();
        WritableRaster dstWR = diff.getRaster();
        boolean refPre = ref.isAlphaPremultiplied();
        if (!refPre) {
            ColorModel cm = ref.getColorModel();
            cm = GraphicsUtil.coerceData((WritableRaster)refWR, (ColorModel)cm, (boolean)true);
            ref = new BufferedImage(cm, refWR, true, null);
        }
        if (!(genPre = gen.isAlphaPremultiplied())) {
            ColorModel cm = gen.getColorModel();
            cm = GraphicsUtil.coerceData((WritableRaster)genWR, (ColorModel)cm, (boolean)true);
            gen = new BufferedImage(cm, genWR, true, null);
        }
        int[] refPix = null;
        int[] genPix = null;
        int[] rangePix = null;
        for (int y = 0; y < h; ++y) {
            refPix = refWR.getPixels(0, y, w, 1, refPix);
            genPix = genWR.getPixels(0, y, w, 1, genPix);
            rangePix = rangeWR.getPixels(0, y, w, 1, rangePix);
            for (int i = 0; i < refPix.length; ++i) {
                int range;
                int val = Math.abs(genPix[i] - refPix[i]);
                if (val > (range = rangePix[i])) {
                    range = val;
                }
                genPix[i] = range;
            }
            dstWR.setPixels(0, y, w, 1, genPix);
        }
        if (!genPre) {
            ColorModel cm = gen.getColorModel();
            cm = GraphicsUtil.coerceData((WritableRaster)genWR, (ColorModel)cm, (boolean)false);
        }
        if (!refPre) {
            ColorModel cm = ref.getColorModel();
            cm = GraphicsUtil.coerceData((WritableRaster)refWR, (ColorModel)cm, (boolean)false);
        }
        return diff;
    }

    public static interface ImageVariants {
        public int getVariantCount();

        public BufferedImage getVariantImage(int var1, ColorSpace var2);
    }
}

