/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.test;

import io.sf.carte.echosvg.test.ResourceLoader;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Paths;

public class TestUtil {
    private TestUtil() {
    }

    public static String getRootProjectURL(Class<?> cl, String projectDirname) {
        String sUrl;
        int testDirIdx;
        String resName = cl.getName().replace(".", "/") + ".class";
        URL url = ResourceLoader.getInstance().getResource(cl, resName);
        if (url == null) {
            url = TestUtil.cwdURL();
        }
        if ((testDirIdx = (sUrl = url.toExternalForm()).lastIndexOf(projectDirname)) != -1) {
            sUrl = sUrl.substring(0, testDirIdx);
        }
        return sUrl;
    }

    private static URL cwdURL() {
        try {
            return Paths.get(".", new String[0]).toAbsolutePath().normalize().toUri().toURL();
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    public static String getProjectBuildURL(Class<?> cl, String projectDirname) {
        String classUrl;
        String resName = cl.getName().replace(".", "/") + ".class";
        URL url = ResourceLoader.getInstance().getResource(cl, resName);
        if (url == null) {
            url = TestUtil.cwdURL();
            File f = new File(url.getFile(), projectDirname);
            if (f.exists()) {
                try {
                    url = new URL(url.getProtocol(), url.getHost(), url.getPort(), f.getAbsolutePath());
                }
                catch (MalformedURLException e) {
                    return null;
                }
                classUrl = url.toExternalForm();
            } else {
                classUrl = url.toExternalForm();
                if (classUrl.lastIndexOf(projectDirname) == -1) {
                    return null;
                }
            }
        } else {
            classUrl = url.toExternalForm();
        }
        int testDirIdx = classUrl.lastIndexOf(projectDirname);
        String buildDir = classUrl.substring(5, testDirIdx + projectDirname.length()) + "/build/";
        return buildDir;
    }
}

