/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.test.image;

import io.sf.carte.echosvg.ext.awt.image.renderable.Filter;
import io.sf.carte.echosvg.ext.awt.image.spi.ImageTagRegistry;
import io.sf.carte.echosvg.ext.awt.image.spi.ImageWriter;
import io.sf.carte.echosvg.ext.awt.image.spi.ImageWriterRegistry;
import io.sf.carte.echosvg.test.image.ImageComparator;
import io.sf.carte.echosvg.test.image.ImageFileBuilder;
import io.sf.carte.echosvg.util.ParsedURL;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;

public class ImageCompareUtil {
    private static final String ERROR_COULD_NOT_LOAD_IMAGE = "ImageCompareUtil error: could not load image ";
    private static final String IMAGE_TYPE_DIFFERENCE = "_diff";
    private static final String IMAGE_TYPE_COMPARISON = "_cmp";
    private String urlAStr;
    private URL urlA;
    private String urlBStr;
    private URL urlB;
    private final ImageFileBuilder filenameUtil;
    private final int pixelThreshold;

    public ImageCompareUtil(ImageFileBuilder fileUtil, int pixelThreshold) {
        this.filenameUtil = fileUtil;
        this.pixelThreshold = pixelThreshold;
    }

    public ImageCompareUtil(ImageFileBuilder fileUtil, int pixelThreshold, String urlA, String urlB) throws MalformedURLException {
        this.filenameUtil = fileUtil;
        this.pixelThreshold = pixelThreshold;
        this.urlAStr = urlA;
        this.urlBStr = urlB;
        this.setImageURLs(urlA, urlB);
    }

    public void setImageURLs(String urlA, String urlB) throws MalformedURLException {
        if (urlA == null) {
            throw new IllegalArgumentException();
        }
        if (urlB == null) {
            throw new IllegalArgumentException();
        }
        this.urlA = this.resolveURL(this.urlAStr);
        this.urlB = this.resolveURL(this.urlBStr);
    }

    private URL resolveURL(String urlStr) throws MalformedURLException {
        URL url;
        try {
            url = new URL(urlStr);
        }
        catch (MalformedURLException e) {
            File file = new File(urlStr);
            if (file.exists()) {
                url = file.toURI().toURL();
            }
            throw e;
        }
        return url;
    }

    public String compare(float allowedPercentBelowThreshold, float allowedPercentOverThreshold) throws IOException {
        BufferedImage imageA = this.getImage(this.urlA);
        if (imageA == null) {
            throw new IllegalStateException(ERROR_COULD_NOT_LOAD_IMAGE + this.urlA.toString());
        }
        BufferedImage imageB = this.getImage(this.urlB);
        if (imageB == null) {
            throw new IllegalStateException(ERROR_COULD_NOT_LOAD_IMAGE + this.urlB.toString());
        }
        short result = this.compareImages(imageA, imageB, allowedPercentBelowThreshold, allowedPercentOverThreshold);
        if (result == 0) {
            return null;
        }
        if (result < 10) {
            return ImageComparator.getResultDescription(result);
        }
        BufferedImage diff = ImageComparator.createDiffImage(imageA, imageB);
        BufferedImage cmp = ImageComparator.createCompareImage(imageA, imageB);
        File tmpDiff = this.imageToFile(diff, IMAGE_TYPE_DIFFERENCE);
        File tmpCmp = this.imageToFile(cmp, IMAGE_TYPE_COMPARISON);
        return "Images are different [" + ImageComparator.getResultDescription(result) + "]. Comp: " + tmpCmp.getAbsolutePath() + " diff: " + tmpDiff.getAbsolutePath();
    }

    public short compareImages(BufferedImage imageA, BufferedImage imageB, float allowedPercentBelowThreshold, float allowedPercentOverThreshold) {
        return ImageComparator.compareImages(imageA, imageB, this.pixelThreshold, allowedPercentBelowThreshold, allowedPercentOverThreshold);
    }

    private File imageToFile(BufferedImage img, String imageType) throws IOException {
        File imageFile = this.obtainDiffCmpFilename(this.urlA, imageType);
        ImageWriter writer = ImageWriterRegistry.getInstance().getWriterFor("image/png");
        try (FileOutputStream out = new FileOutputStream(imageFile);){
            writer.writeImage((RenderedImage)img, (OutputStream)out);
        }
        return imageFile;
    }

    private File obtainDiffCmpFilename(URL pngURL, String imageType) throws IOException {
        return this.filenameUtil.createImageFile(pngURL, imageType, ".png");
    }

    private BufferedImage getImage(URL url) {
        ImageTagRegistry reg = ImageTagRegistry.getRegistry();
        Filter filt = reg.readURL(new ParsedURL(url));
        if (filt == null) {
            return null;
        }
        RenderedImage red = filt.createDefaultRendering();
        if (red == null) {
            return null;
        }
        BufferedImage img = new BufferedImage(red.getWidth(), red.getHeight(), 2);
        red.copyData(img.getRaster());
        return img;
    }
}

