/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.test;

import io.sf.carte.echosvg.anim.dom.SAXSVGDocumentFactory;
import io.sf.carte.echosvg.test.ResourceLoader;
import io.sf.jclf.text.TokenParser;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Objects;
import org.w3c.dom.DocumentType;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.svg.SVGDocument;

public class TestUtil {
    private TestUtil() {
    }

    public static String getRootProjectURL(Class<?> cl, String projectDirname) {
        String sUrl;
        int testDirIdx;
        String resName = cl.getName().replace(".", "/") + ".class";
        URL url = ResourceLoader.getInstance().getResource(cl, resName);
        if (url == null) {
            url = TestUtil.cwdURL();
        }
        if ((testDirIdx = (sUrl = url.toExternalForm()).lastIndexOf(projectDirname)) != -1) {
            sUrl = sUrl.substring(0, testDirIdx);
        }
        return sUrl;
    }

    private static URL cwdURL() {
        try {
            return Paths.get(".", new String[0]).toAbsolutePath().normalize().toUri().toURL();
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    public static String getProjectBuildURL(Class<?> cl, String projectDirname) {
        String classUrl;
        String resName = cl.getName().replace(".", "/") + ".class";
        URL url = ResourceLoader.getInstance().getResource(cl, resName);
        if (url == null) {
            url = TestUtil.cwdURL();
            File f = new File(url.getFile(), projectDirname);
            if (f.exists()) {
                try {
                    url = new URL(url.getProtocol(), url.getHost(), url.getPort(), f.getAbsolutePath());
                }
                catch (MalformedURLException e) {
                    return null;
                }
                classUrl = url.toExternalForm();
            } else {
                classUrl = url.toExternalForm();
                if (classUrl.lastIndexOf(projectDirname) == -1) {
                    return null;
                }
            }
        } else {
            classUrl = url.toExternalForm();
        }
        int testDirIdx = classUrl.lastIndexOf(projectDirname);
        String buildDir = classUrl.substring(5, testDirIdx + projectDirname.length()) + "/build/";
        return buildDir;
    }

    public static String xmlDiff(URL refURL, byte[] data, File candidateFile) throws IOException {
        BufferedReader refReader;
        InputStreamReader r;
        try {
            InputStream is = refURL.openStream();
            r = new InputStreamReader(is);
            refReader = new BufferedReader(r);
        }
        catch (FileNotFoundException e) {
            TestUtil.save(data, candidateFile);
            return e.getMessage();
        }
        catch (IOException e) {
            TestUtil.save(data, candidateFile);
            throw e;
        }
        ByteArrayInputStream dataIS = new ByteArrayInputStream(data);
        r = new InputStreamReader(dataIS);
        BufferedReader dataReader = new BufferedReader(r);
        try {
            String refStr = "";
            String dataStr = "";
            int line = 0;
            int cn = 0;
            while (refStr != null && dataStr != null && (refStr.equals(dataStr) || (cn = TestUtil.lineDiff(refStr, dataStr)) == -1)) {
                refStr = refReader.readLine();
                dataStr = dataReader.readLine();
                ++line;
            }
            refReader.close();
            if (refStr == null && dataStr == null) {
                return null;
            }
            if (TestUtil.compareDOM(refURL, data)) {
                return null;
            }
            TestUtil.save(data, candidateFile);
            String expectedChar = "<eol>";
            if (cn >= 0 && refStr != null && refStr.length() > cn) {
                expectedChar = refStr.substring(cn, cn + 1);
            }
            String foundChar = "<null>";
            if (cn >= 0 && dataStr != null && dataStr.length() > cn) {
                foundChar = dataStr.substring(cn, cn + 1);
            }
            if (expectedChar.equals(" ")) {
                expectedChar = "' '";
            }
            if (foundChar.equals(" ")) {
                foundChar = "' '";
            }
            return "Expected " + expectedChar + ", found " + foundChar + " at line/column " + line + '/' + (cn + 1) + ":\n" + refStr + '\n' + dataStr;
        }
        catch (Exception e) {
            TestUtil.save(data, candidateFile);
            return "Error while comparing images: " + e.getMessage();
        }
    }

    public static int lineDiff(String refLine, String checkLine) {
        ArrayList<String> refTk = new ArrayList<String>();
        TokenParser st = new TokenParser(refLine, " ;{}", "\"", true);
        while (st.hasMoreTokens()) {
            String s = st.nextToken();
            refTk.add(s);
        }
        ArrayList<String> checkTk = new ArrayList<String>(refTk.size() + 2);
        st = new TokenParser(checkLine, " ;{}", "\"", true);
        while (st.hasMoreTokens()) {
            String s = st.nextToken();
            checkTk.add(s);
        }
        if (refTk.size() == checkTk.size()) {
            for (String s : refTk) {
                if (checkTk.contains(s)) continue;
                return TestUtil.computeColumnNumber(refLine, checkLine, refLine.indexOf(s));
            }
            return -1;
        }
        return TestUtil.computeColumnNumber(refLine, checkLine, 0);
    }

    private static int computeColumnNumber(String aStr, String bStr, int offset) {
        int i;
        if (aStr == null || bStr == null) {
            return -1;
        }
        int n = aStr.length();
        for (i = offset; i < n; ++i) {
            char b;
            char a = aStr.charAt(i);
            if (i >= bStr.length() || a != (b = bStr.charAt(i))) break;
        }
        return i;
    }

    private static boolean compareDOM(URL refURL, byte[] data) throws IOException {
        ByteArrayInputStream newStream = new ByteArrayInputStream(data);
        InputStream refStream = refURL.openStream();
        String documentURI = refURL.toExternalForm();
        SAXSVGDocumentFactory factory = new SAXSVGDocumentFactory();
        SVGDocument refDoc = factory.createDocument(documentURI, refStream, "utf-8");
        refStream.close();
        SVGDocument newDoc = factory.createDocument(documentURI, (InputStream)newStream, "utf-8");
        return TestUtil.isEquivalentNode((Node)refDoc, (Node)newDoc);
    }

    private static boolean isEquivalentNode(Node node, Node other) {
        if (other == null) {
            return false;
        }
        short nt = other.getNodeType();
        if (!(nt == node.getNodeType() && Objects.equals(node.getNodeName(), other.getNodeName()) && Objects.equals(node.getLocalName(), other.getLocalName()) && Objects.equals(node.getPrefix(), other.getPrefix()) && Objects.equals(node.getNodeValue(), other.getNodeValue()) && TestUtil.compareNamedNodeMaps(node.getAttributes(), other.getAttributes()))) {
            return false;
        }
        if (nt == 10) {
            DocumentType dt1 = (DocumentType)node;
            DocumentType dt2 = (DocumentType)other;
            if (!(Objects.equals(dt1.getPublicId(), dt2.getPublicId()) && Objects.equals(dt1.getSystemId(), dt2.getSystemId()) && Objects.equals(dt1.getInternalSubset(), dt2.getInternalSubset()) && TestUtil.compareNamedNodeMaps(dt1.getEntities(), dt2.getEntities()) && TestUtil.compareNamedNodeMaps(dt1.getNotations(), dt2.getNotations()))) {
                return false;
            }
        }
        Node n = node.getFirstChild();
        Node m = other.getFirstChild();
        if (n != null ? !TestUtil.isEquivalentNode(n, m) : m != null) {
            return false;
        }
        n = node.getNextSibling();
        m = other.getNextSibling();
        return !(n != null ? !TestUtil.isEquivalentNode(n, m) : m != null);
    }

    private static boolean compareNamedNodeMaps(NamedNodeMap attributes, NamedNodeMap attributes2) {
        int nl2;
        if (attributes == null) {
            return attributes2 == null;
        }
        if (attributes2 == null) {
            return false;
        }
        int nl = attributes.getLength();
        if (nl != (nl2 = attributes2.getLength())) {
            return false;
        }
        for (int i = 0; i < nl; ++i) {
            Node attr = attributes.item(i);
            String localName = attr.getLocalName();
            Node attr2 = localName != null ? attributes2.getNamedItemNS(attr.getNamespaceURI(), localName) : attributes2.getNamedItem(attr.getNodeName());
            if (attr2 == null) {
                return false;
            }
            if (TestUtil.isEquivalentNode(attr, attr2)) continue;
            return false;
        }
        return true;
    }

    private static void save(byte[] data, File candidateFile) throws IOException {
        if (candidateFile == null) {
            return;
        }
        File parentDir = candidateFile.getParentFile();
        if (!parentDir.exists() && !parentDir.mkdir()) {
            return;
        }
        try (FileOutputStream os = new FileOutputStream(candidateFile);){
            os.write(data);
        }
    }
}

