/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.test.image;

import io.sf.carte.echosvg.test.image.ImageFileBuilder;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;

public class TempImageFiles
implements ImageFileBuilder {
    private static final String TEST_IMAGES_PATH = "/reports/tests/test/images";
    private final String projectBuildURL;
    private final String imageSubpath;

    public TempImageFiles(String projectBuildURL) {
        this(projectBuildURL, TEST_IMAGES_PATH);
    }

    public TempImageFiles(String projectBuildURL, String imageSubpath) {
        this.projectBuildURL = projectBuildURL;
        this.imageSubpath = imageSubpath;
    }

    @Override
    public File createImageFile(URL imageUrl, CharSequence fileSuffix, CharSequence dotExtension) throws IOException {
        String path = imageUrl.getPath();
        int idx = path.lastIndexOf(47);
        if (idx != -1) {
            int dotIndex = path.lastIndexOf(46);
            if (dotIndex == -1) {
                dotIndex = path.length();
            }
            CharSequence imageName = path.subSequence(idx + 1, dotIndex);
            StringBuilder buf = new StringBuilder(imageName.length() + fileSuffix.length() + dotExtension.length());
            buf.append(imageName).append(fileSuffix).append(dotExtension);
            return this.createImageFile(buf.toString());
        }
        StringBuilder buf = new StringBuilder(path.length() + fileSuffix.length() + dotExtension.length());
        buf.append(path).append(fileSuffix).append(dotExtension);
        return Files.createTempFile("TempImageFiles", buf.toString(), new FileAttribute[0]).toFile();
    }

    @Override
    public File createImageFile(String imageNameWithExtension) throws IOException {
        File imgDir;
        File buildDir;
        if (this.projectBuildURL != null && (buildDir = new File(this.projectBuildURL)).exists() && ((imgDir = new File(buildDir + this.imageSubpath)).exists() || imgDir.mkdirs())) {
            return new File(imgDir, imageNameWithExtension);
        }
        return Files.createTempFile("TempImageFiles", imageNameWithExtension, new FileAttribute[0]).toFile();
    }
}

