/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.test.svg;

import io.sf.carte.echosvg.ext.awt.image.codec.png.PNGDecodeParam;
import io.sf.carte.echosvg.ext.awt.image.codec.png.PNGEncodeParam;
import io.sf.carte.echosvg.ext.awt.image.codec.png.PNGImageDecoder;
import io.sf.carte.echosvg.ext.awt.image.renderable.Filter;
import io.sf.carte.echosvg.ext.awt.image.spi.ImageTagRegistry;
import io.sf.carte.echosvg.ext.awt.image.spi.ImageWriter;
import io.sf.carte.echosvg.ext.awt.image.spi.ImageWriterRegistry;
import io.sf.carte.echosvg.test.TestUtil;
import io.sf.carte.echosvg.test.image.ImageComparator;
import io.sf.carte.echosvg.test.image.TempImageFiles;
import io.sf.carte.echosvg.test.svg.Messages;
import io.sf.carte.echosvg.transcoder.TranscoderException;
import io.sf.carte.echosvg.util.ParsedURL;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.color.ColorSpace;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;

public abstract class AbstractRenderingAccuracyTest {
    private static final String COULD_NOT_LOAD_IMAGE = "SVGRenderingAccuracyTest.message.error.could.not.load.image";
    private static final String COULD_NOT_OPEN_VARIATION_URL = "SVGRenderingAccuracyTest.message.warning.could.not.open.variation.url";
    private static final String CONFIGURATION_RESOURCES = "io.sf.carte.echosvg.test.svg.resources.Configuration";
    private static final String IMAGE_TYPE_COMPARISON = "_cmp";
    private static final String IMAGE_TYPE_DIFF = "_diff";
    private static final String IMAGE_FILE_DOT_EXTENSION = ".png";
    static ResourceBundle configuration = ResourceBundle.getBundle("io.sf.carte.echosvg.test.svg.resources.Configuration", Locale.getDefault());
    private final String PROJECT_ROOT_URL = TestUtil.getRootProjectURL(this.getClass(), (String)this.getProjectName());
    private final TempImageFiles tmpUtil = new TempImageFiles(TestUtil.getProjectBuildURL(this.getClass(), (String)this.getProjectName()));
    private URL svgURL;
    protected URL refImgURL;
    private final int pixelThreshold;
    protected List<URL> variationURLs;
    private String saveRangeVariation;
    private String savePlatformVariation;
    private File candidateReference;
    protected static File tempDirectory;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static File getTempDirectory() {
        if (tempDirectory != null) return tempDirectory;
        String tmpDir = System.getProperty("java.io.tmpdir");
        if (tmpDir == null) {
            throw new RuntimeException();
        }
        Class<AbstractRenderingAccuracyTest> clazz = AbstractRenderingAccuracyTest.class;
        synchronized (AbstractRenderingAccuracyTest.class) {
            if (tempDirectory == null) {
                tempDirectory = new File(tmpDir);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            if (tempDirectory.exists()) return tempDirectory;
            throw new RuntimeException();
        }
    }

    public AbstractRenderingAccuracyTest(int pixelThreshold, String svgURL, String refImgURL) throws MalformedURLException {
        this.pixelThreshold = pixelThreshold;
        this.setInputAndRefURL(svgURL, refImgURL);
    }

    protected AbstractRenderingAccuracyTest(int pixelThreshold) {
        this.pixelThreshold = pixelThreshold;
    }

    public void setInputAndRefURL(String svgURL, String refImgURL) throws MalformedURLException {
        if (svgURL == null) {
            throw new IllegalArgumentException();
        }
        if (refImgURL == null) {
            throw new IllegalArgumentException();
        }
        this.svgURL = this.resolveURL(svgURL);
        this.refImgURL = this.resolveURL(refImgURL);
    }

    public URL resolveURL(String url) throws MalformedURLException {
        if (url.startsWith("file:")) {
            return new URL(url);
        }
        return new URL(this.PROJECT_ROOT_URL + url);
    }

    protected abstract String getProjectName();

    public void setSaveRangeVariation(String saveVariation) {
        this.saveRangeVariation = saveVariation;
    }

    private String getSaveRangeVariation() {
        return this.saveRangeVariation;
    }

    public void setSavePlatformVariation(String saveVariation) {
        this.savePlatformVariation = saveVariation;
    }

    private String getSavePlatformVariation() {
        return this.savePlatformVariation;
    }

    public String[] getVariationURLs() {
        if (this.variationURLs != null) {
            return this.variationURLs.toArray(new String[0]);
        }
        return null;
    }

    public void addVariationURL(String variationURL) {
        if (this.variationURLs == null) {
            this.variationURLs = new LinkedList<URL>();
        }
        try {
            this.variationURLs.add(this.resolveURL(variationURL));
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
    }

    public void setCandidateReference(File candidateReference) {
        this.candidateReference = candidateReference;
    }

    public File getCandidateReference() {
        return this.candidateReference;
    }

    protected CharSequence getImageSuffix() {
        return "";
    }

    public String getURI() {
        return this.svgURL.toString();
    }

    protected URL getURL() {
        return this.svgURL;
    }

    public void runTest(float allowedPercentBelowThreshold, float allowedPercentOverThreshold) throws TranscoderException, IOException {
        this.runTest(allowedPercentBelowThreshold, allowedPercentOverThreshold, false);
    }

    public void runTest(float allowedPercentBelowThreshold, float allowedPercentOverThreshold, boolean checkMetadata) throws TranscoderException, IOException {
        if (this.candidateReference != null && this.candidateReference.exists()) {
            this.candidateReference.delete();
        }
        File tmpFile = null;
        if (this.candidateReference != null) {
            File parentDir;
            tmpFile = this.candidateReference;
            if (!(tmpFile.exists() || (parentDir = tmpFile.getParentFile()).exists() || parentDir.mkdir())) {
                throw new IOException("Could not create directory: " + parentDir.getAbsolutePath());
            }
        } else {
            tmpFile = this.tmpUtil.createImageFile(this.svgURL, this.getImageSuffix(), (CharSequence)IMAGE_FILE_DOT_EXTENSION);
        }
        try (FileOutputStream tmpFileOS = new FileOutputStream(tmpFile);){
            this.encode(this.svgURL, tmpFileOS);
        }
        BufferedImage ref = this.getImage(this.refImgURL);
        BufferedImage gen = this.getImage(tmpFile);
        short result = this.compareImages(ref, gen, allowedPercentBelowThreshold, allowedPercentOverThreshold);
        if (result == 0) {
            if (checkMetadata) {
                this.matchDecodeMetadata(tmpFile);
            }
            tmpFile.delete();
            return;
        }
        Variants variants = null;
        if (this.variationURLs != null) {
            ref = this.getImage(this.refImgURL);
            short variantResult = ImageComparator.compareVariantImages((BufferedImage)ref, (BufferedImage)(gen = this.getImage(tmpFile)), (int)this.pixelThreshold, (float)allowedPercentBelowThreshold, (float)allowedPercentOverThreshold, (ImageComparator.ImageVariants)(variants = new Variants()));
            if (variantResult == 0) {
                if (checkMetadata) {
                    this.matchDecodeMetadata(tmpFile);
                }
                tmpFile.delete();
                return;
            }
            if (variantResult == 21) {
                result = variantResult;
            }
        }
        if (this.getSaveRangeVariation() != null) {
            ref = this.getImage(this.refImgURL);
            gen = this.getImage(tmpFile);
            this.saveRangeDiff(ref, gen, variants);
        }
        ref = this.getImage(this.refImgURL);
        gen = this.getImage(tmpFile);
        BufferedImage diff = ImageComparator.createDiffImage((BufferedImage)ref, (BufferedImage)gen);
        if (this.getSavePlatformVariation() != null) {
            this.saveImage(diff, new File(this.getSavePlatformVariation()));
        }
        BufferedImage cmp = ImageComparator.createCompareImage((BufferedImage)ref, (BufferedImage)gen);
        File cmpFile = this.imageToFile(cmp, IMAGE_TYPE_COMPARISON);
        File diffFile = this.imageToFile(diff, IMAGE_TYPE_DIFF);
        if (this.candidateReference == null) {
            tmpFile.delete();
        }
        this.failTest("Rendering not accurate [" + ImageComparator.getResultDescription((short)result) + "], see generated images: " + diffFile.getAbsolutePath() + ", " + cmpFile.getAbsolutePath());
    }

    private void matchDecodeMetadata(File candFile) throws IOException {
        PNGDecodeParam refParam = new PNGDecodeParam();
        PNGDecodeParam candParam = new PNGDecodeParam();
        refParam.setGenerateEncodeParam(true);
        candParam.setGenerateEncodeParam(true);
        this.decodeNative(this.refImgURL, refParam);
        this.decodeNative(candFile.toURI().toURL(), candParam);
        PNGEncodeParam refEnc = refParam.getEncodeParam();
        PNGEncodeParam candEnc = candParam.getEncodeParam();
        if (refEnc.getICCProfileName() != null) {
            if (candEnc.getICCProfileName() == null) {
                this.failTest("Candidate is missing ICC profile data.");
            }
            if (!refEnc.getICCProfileName().equals(candEnc.getICCProfileName())) {
                this.failTest("ICC profile name mismatch: expected '" + refEnc.getICCProfileName() + "' but got '" + candEnc.getICCProfileName() + "'.");
            }
        } else if (candEnc.getICCProfileName() != null) {
            this.failTest("Candidate has unexpected ICC profile data.");
        }
        if (refEnc.isTextSet()) {
            if (!candEnc.isTextSet()) {
                this.failTest("Candidate is missing tEXt chunk.");
            }
            if (!Arrays.equals(refEnc.getText(), candEnc.getText())) {
                this.failTest("tEXt data mismatch.");
            }
        } else if (candEnc.isTextSet()) {
            this.failTest("Candidate has unexpected tEXt data.");
        }
        if (refEnc.isInternationalTextSet()) {
            if (!candEnc.isInternationalTextSet()) {
                this.failTest("Candidate is missing iTXt chunk.");
            }
            if (!Arrays.equals(refEnc.getInternationalText(), candEnc.getInternationalText())) {
                this.failTest("iTXt data mismatch.");
            }
        } else if (candEnc.isInternationalTextSet()) {
            this.failTest("Candidate has unexpected iTXt data.");
        }
        if (refEnc.isCompressedTextSet()) {
            if (!candEnc.isCompressedTextSet()) {
                this.failTest("Candidate is missing zTXt chunk.");
            }
            if (!Arrays.equals(refEnc.getCompressedText(), candEnc.getCompressedText())) {
                this.failTest("zTXt data mismatch.");
            }
        } else if (candEnc.isCompressedTextSet()) {
            this.failTest("Candidate has unexpected zTXt data.");
        }
    }

    private BufferedImage decodeNative(URL url, PNGDecodeParam decParam) throws IOException {
        RenderedImage decodedRenderedImage;
        try (InputStream is = url.openStream();){
            PNGImageDecoder pngImageDecoder = new PNGImageDecoder(is, decParam);
            decodedRenderedImage = pngImageDecoder.decodeAsRenderedImage(0);
        }
        BufferedImage decodedImage = null;
        if (decodedRenderedImage instanceof BufferedImage) {
            decodedImage = (BufferedImage)decodedRenderedImage;
        } else {
            ColorModel cm = decodedRenderedImage.getColorModel();
            if (cm.getColorSpace().isCS_sRGB()) {
                decodedImage = new BufferedImage(decodedRenderedImage.getWidth(), decodedRenderedImage.getHeight(), 2);
            } else {
                Point loc = new Point(0, 0);
                WritableRaster raster = Raster.createWritableRaster(decodedRenderedImage.getSampleModel(), loc);
                decodedImage = new BufferedImage(cm, raster, false, null);
            }
            Graphics2D ig = decodedImage.createGraphics();
            ig.drawRenderedImage(decodedRenderedImage, new AffineTransform());
            ig.dispose();
        }
        return decodedImage;
    }

    protected abstract void failTest(String var1);

    private void saveRangeDiff(BufferedImage ref, BufferedImage gen, Variants variants) throws IOException {
        if (variants != null) {
            variants.setTrace(false);
            BufferedImage rangeDiff = variants.getVariantImage(0, ref.getColorModel().getColorSpace());
            if (rangeDiff != null) {
                BufferedImage exactDiff = ImageComparator.createMergedDiffImage((BufferedImage)ref, (BufferedImage)gen, (BufferedImage)rangeDiff);
                this.saveImage(exactDiff, new File(this.getSaveRangeVariation()));
                return;
            }
        }
        BufferedImage exactDiff = ImageComparator.createExactDiffImage((BufferedImage)ref, (BufferedImage)gen);
        this.saveImage(exactDiff, new File(this.getSaveRangeVariation()));
    }

    short compareImages(BufferedImage imageA, BufferedImage imageB, float allowedPercentBelowThreshold, float allowedPercentOverThreshold) {
        return ImageComparator.compareImages((BufferedImage)imageA, (BufferedImage)imageB, (int)this.pixelThreshold, (float)allowedPercentBelowThreshold, (float)allowedPercentOverThreshold);
    }

    protected abstract void encode(URL var1, FileOutputStream var2) throws TranscoderException, IOException;

    private void saveImage(BufferedImage img, File imgFile) throws IOException {
        if (!imgFile.exists()) {
            File parentDir = imgFile.getParentFile();
            if (!parentDir.exists() && !parentDir.mkdir()) {
                return;
            }
            imgFile.createNewFile();
        }
        try (FileOutputStream out = new FileOutputStream(imgFile);){
            this.saveImage(img, out);
        }
    }

    void saveImage(BufferedImage img, OutputStream os) throws IOException {
        ImageWriter writer = ImageWriterRegistry.getInstance().getWriterFor("image/png");
        writer.writeImage((RenderedImage)img, os);
    }

    private BufferedImage getImage(File file) throws IOException {
        return this.getImage(file.toURI().toURL());
    }

    private BufferedImage getImage(URL url) throws IOException {
        ImageTagRegistry reg = ImageTagRegistry.getRegistry();
        Filter filt = reg.readURL(new ParsedURL(url));
        if (filt == null) {
            throw new IOException(Messages.formatMessage(COULD_NOT_LOAD_IMAGE, new Object[]{url.toString()}));
        }
        RenderedImage red = filt.createDefaultRendering();
        if (red == null) {
            throw new IOException(Messages.formatMessage(COULD_NOT_LOAD_IMAGE, new Object[]{url.toString()}));
        }
        BufferedImage img = new BufferedImage(red.getWidth(), red.getHeight(), 2);
        red.copyData(img.getRaster());
        return img;
    }

    private File imageToFile(BufferedImage img, String imageType) throws IOException {
        File imageFile = this.tmpUtil.createImageFile(this.svgURL, (CharSequence)(this.getImageSuffix() + imageType), (CharSequence)IMAGE_FILE_DOT_EXTENSION);
        this.saveImage(img, imageFile);
        return imageFile;
    }

    private class Variants
    implements ImageComparator.ImageVariants {
        private boolean trace = true;

        private Variants() {
        }

        void setTrace(boolean trace) {
            this.trace = trace;
        }

        public int getVariantCount() {
            return AbstractRenderingAccuracyTest.this.variationURLs.size();
        }

        public BufferedImage getVariantImage(int index, ColorSpace colorSpace) {
            InputStream variationURLStream;
            URL variationURL;
            try {
                variationURL = AbstractRenderingAccuracyTest.this.variationURLs.get(index);
            }
            catch (IndexOutOfBoundsException e) {
                return null;
            }
            try {
                variationURLStream = variationURL.openStream();
            }
            catch (IOException e) {
                if (this.trace) {
                    System.err.println(Messages.formatMessage(AbstractRenderingAccuracyTest.COULD_NOT_OPEN_VARIATION_URL, new Object[]{variationURL.toString()}));
                }
                return null;
            }
            ImageTagRegistry reg = ImageTagRegistry.getRegistry();
            Filter filt = reg.readStream(variationURLStream, colorSpace);
            if (filt == null) {
                if (this.trace) {
                    System.err.println(Messages.formatMessage(AbstractRenderingAccuracyTest.COULD_NOT_OPEN_VARIATION_URL, new Object[]{variationURL.toString()}));
                }
                try {
                    variationURLStream.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                return null;
            }
            RenderedImage red = filt.createDefaultRendering();
            if (red == null) {
                if (this.trace) {
                    System.err.println(Messages.formatMessage(AbstractRenderingAccuracyTest.COULD_NOT_OPEN_VARIATION_URL, new Object[]{variationURL.toString()}));
                }
                try {
                    variationURLStream.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                return null;
            }
            BufferedImage img = new BufferedImage(red.getWidth(), red.getHeight(), 2);
            red.copyData(img.getRaster());
            try {
                variationURLStream.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return img;
        }
    }
}

