/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.transcoder;

import io.sf.carte.echosvg.dom.GenericDOMImplementation;
import io.sf.carte.echosvg.dom.util.DocumentFactory;
import io.sf.carte.echosvg.transcoder.TranscodingHints;
import io.sf.carte.echosvg.transcoder.XMLAbstractTranscoder;
import io.sf.carte.echosvg.transcoder.keys.BooleanKey;
import io.sf.carte.echosvg.transcoder.keys.FloatKey;
import io.sf.carte.echosvg.transcoder.keys.LengthKey;
import io.sf.carte.echosvg.transcoder.keys.Rectangle2DKey;
import io.sf.carte.echosvg.transcoder.keys.StringKey;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import org.w3c.dom.DOMImplementation;

public abstract class SVGAbstractTranscoder
extends XMLAbstractTranscoder {
    public static final String DEFAULT_DEFAULT_FONT_FAMILY = "Arial, Helvetica, sans-serif";
    private Rectangle2D curAOI;
    private AffineTransform curTxf;
    protected float width = 400.0f;
    protected float height = 400.0f;
    public static final TranscodingHints.Key KEY_WIDTH = new LengthKey();
    public static final TranscodingHints.Key KEY_HEIGHT = new LengthKey();
    public static final TranscodingHints.Key KEY_MAX_WIDTH = new LengthKey();
    public static final TranscodingHints.Key KEY_MAX_HEIGHT = new LengthKey();
    public static final TranscodingHints.Key KEY_AOI = new Rectangle2DKey();
    public static final TranscodingHints.Key KEY_LANGUAGE = new StringKey();
    public static final TranscodingHints.Key KEY_MEDIA = new StringKey();
    public static final TranscodingHints.Key KEY_PREFERS_COLOR_SCHEME = new StringKey();
    public static final TranscodingHints.Key KEY_SVG_SELECTOR = new StringKey();
    public static final TranscodingHints.Key KEY_DEFAULT_FONT_FAMILY = new StringKey();
    public static final TranscodingHints.Key KEY_ALTERNATE_STYLESHEET = new StringKey();
    public static final TranscodingHints.Key KEY_USER_STYLESHEET_URI = new StringKey();
    @Deprecated
    public static final TranscodingHints.Key KEY_PIXEL_UNIT_TO_MILLIMETER;
    @Deprecated
    public static final TranscodingHints.Key KEY_PIXEL_TO_MM;
    public static final TranscodingHints.Key KEY_RESOLUTION_DPI;
    public static final TranscodingHints.Key KEY_EXECUTE_ONLOAD;
    public static final TranscodingHints.Key KEY_SNAPSHOT_TIME;
    public static final TranscodingHints.Key KEY_ALLOWED_SCRIPT_TYPES;
    public static final String DEFAULT_ALLOWED_SCRIPT_TYPES = "text/ecmascript, application/ecmascript, text/javascript, application/javascript, application/java-archive";
    public static final TranscodingHints.Key KEY_CONSTRAIN_SCRIPT_ORIGIN;
    public static final TranscodingHints.Key KEY_ALLOW_EXTERNAL_RESOURCES;

    protected SVGAbstractTranscoder() {
        this.hints.put(KEY_DOCUMENT_ELEMENT_NAMESPACE_URI, (Object)"http://www.w3.org/2000/svg");
        this.hints.put(KEY_DOCUMENT_ELEMENT, (Object)"svg");
        this.hints.put(KEY_MEDIA, (Object)"screen");
        this.hints.put(KEY_DEFAULT_FONT_FAMILY, (Object)DEFAULT_DEFAULT_FONT_FAMILY);
        this.hints.put(KEY_EXECUTE_ONLOAD, (Object)Boolean.FALSE);
        this.hints.put(KEY_ALLOWED_SCRIPT_TYPES, (Object)DEFAULT_ALLOWED_SCRIPT_TYPES);
    }

    @Override
    protected DocumentFactory createDocumentFactory(String namespaceURI) {
        DocumentFactory f;
        if ("http://www.w3.org/2000/svg".equalsIgnoreCase(namespaceURI) || namespaceURI == null) {
            f = this.createSVGDocumentFactory();
        } else {
            DOMImplementation domImpl = (DOMImplementation)this.hints.get(KEY_DOM_IMPLEMENTATION);
            if (domImpl == null) {
                domImpl = GenericDOMImplementation.getDOMImplementation();
            }
            f = this.createDocumentFactory(domImpl);
        }
        return f;
    }

    protected abstract DocumentFactory createSVGDocumentFactory();

    Rectangle2D getCurrentAOI() {
        return this.curAOI;
    }

    protected void setCurrentAOI(Rectangle2D curAOI) {
        this.curAOI = curAOI;
    }

    protected AffineTransform getCurrentAOITransform() {
        return this.curTxf;
    }

    protected void setCurrentAOITransform(AffineTransform curTxf) {
        this.curTxf = curTxf;
    }

    protected void setWidth(float width) {
        this.width = width;
    }

    protected void setHeight(float height) {
        this.height = height;
    }

    protected void setImageSize(float docWidth, float docHeight) {
        float imgWidth = -1.0f;
        if (this.hints.containsKey(KEY_WIDTH)) {
            imgWidth = ((Float)this.hints.get(KEY_WIDTH)).floatValue();
        }
        float imgHeight = -1.0f;
        if (this.hints.containsKey(KEY_HEIGHT)) {
            imgHeight = ((Float)this.hints.get(KEY_HEIGHT)).floatValue();
        }
        if (imgWidth > 0.0f && imgHeight > 0.0f) {
            this.width = imgWidth;
            this.height = imgHeight;
        } else if (imgHeight > 0.0f) {
            this.width = docWidth * imgHeight / docHeight;
            this.height = imgHeight;
        } else if (imgWidth > 0.0f) {
            this.width = imgWidth;
            this.height = docHeight * imgWidth / docWidth;
        } else {
            this.width = docWidth;
            this.height = docHeight;
        }
        float imgMaxWidth = -1.0f;
        if (this.hints.containsKey(KEY_MAX_WIDTH)) {
            imgMaxWidth = ((Float)this.hints.get(KEY_MAX_WIDTH)).floatValue();
        }
        float imgMaxHeight = -1.0f;
        if (this.hints.containsKey(KEY_MAX_HEIGHT)) {
            imgMaxHeight = ((Float)this.hints.get(KEY_MAX_HEIGHT)).floatValue();
        }
        if (imgMaxHeight > 0.0f && this.height > imgMaxHeight) {
            this.width = docWidth * imgMaxHeight / docHeight;
            this.height = imgMaxHeight;
        }
        if (imgMaxWidth > 0.0f && this.width > imgMaxWidth) {
            this.width = imgMaxWidth;
            this.height = docHeight * imgMaxWidth / docWidth;
        }
    }

    static {
        KEY_PIXEL_TO_MM = KEY_PIXEL_UNIT_TO_MILLIMETER = new FloatKey();
        KEY_RESOLUTION_DPI = new FloatKey();
        KEY_EXECUTE_ONLOAD = new BooleanKey();
        KEY_SNAPSHOT_TIME = new FloatKey();
        KEY_ALLOWED_SCRIPT_TYPES = new StringKey();
        KEY_CONSTRAIN_SCRIPT_ORIGIN = new BooleanKey();
        KEY_ALLOW_EXTERNAL_RESOURCES = new BooleanKey();
    }
}

