/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.transcoder;

import io.sf.carte.echosvg.dom.GenericDOMImplementation;
import io.sf.carte.echosvg.dom.util.DocumentFactory;
import io.sf.carte.echosvg.dom.util.SAXDocumentFactory;
import io.sf.carte.echosvg.transcoder.AbstractTranscoder;
import io.sf.carte.echosvg.transcoder.TranscoderException;
import io.sf.carte.echosvg.transcoder.TranscoderInput;
import io.sf.carte.echosvg.transcoder.TranscoderOutput;
import io.sf.carte.echosvg.transcoder.TranscodingHints;
import io.sf.carte.echosvg.transcoder.keys.BooleanKey;
import io.sf.carte.echosvg.transcoder.keys.DOMImplementationKey;
import io.sf.carte.echosvg.transcoder.keys.StringKey;
import java.io.IOException;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public abstract class XMLAbstractTranscoder
extends AbstractTranscoder {
    public static final TranscodingHints.Key KEY_XML_PARSER_VALIDATING = new BooleanKey();
    public static final TranscodingHints.Key KEY_DOCUMENT_ELEMENT = new StringKey();
    public static final TranscodingHints.Key KEY_DOCUMENT_ELEMENT_NAMESPACE_URI = new StringKey();
    public static final TranscodingHints.Key KEY_DOM_IMPLEMENTATION = new DOMImplementationKey();

    protected XMLAbstractTranscoder() {
        this.hints.put(KEY_XML_PARSER_VALIDATING, (Object)Boolean.FALSE);
    }

    @Override
    public void transcode(TranscoderInput input, TranscoderOutput output) throws TranscoderException {
        Document document = null;
        document = input.getDocument() != null ? input.getDocument() : this.loadDocument(input);
        if (document != null) {
            String uri = input.getURI();
            try {
                this.transcode(document, uri, output);
            }
            catch (TranscoderException ex) {
                this.handler.fatalError(ex);
                return;
            }
        }
    }

    private Document loadDocument(TranscoderInput input) throws TranscoderException {
        String namespaceURI = (String)this.hints.get(KEY_DOCUMENT_ELEMENT_NAMESPACE_URI);
        DocumentFactory f = this.createDocumentFactory(namespaceURI);
        Object xmlParserValidating = this.hints.get(KEY_XML_PARSER_VALIDATING);
        boolean validating = xmlParserValidating != null && (Boolean)xmlParserValidating != false;
        f.setValidating(validating);
        f.setXMLReader(input.getXMLReader());
        InputSource source = new InputSource();
        source.setSystemId(input.getURI());
        source.setByteStream(input.getInputStream());
        source.setEncoding(input.getEncoding());
        source.setCharacterStream(input.getReader());
        Document document = null;
        try {
            document = f.parse(source);
        }
        catch (IOException | SAXException ex) {
            this.handler.fatalError(new TranscoderException(ex));
        }
        return document;
    }

    protected DocumentFactory createDocumentFactory(String namespaceURI) {
        DOMImplementation domImpl = (DOMImplementation)this.hints.get(KEY_DOM_IMPLEMENTATION);
        if (domImpl == null) {
            domImpl = GenericDOMImplementation.getDOMImplementation();
        }
        return this.createDocumentFactory(domImpl);
    }

    protected DocumentFactory createDocumentFactory(DOMImplementation domImpl) {
        return new SAXDocumentFactory(domImpl);
    }

    protected abstract void transcode(Document var1, String var2, TranscoderOutput var3) throws TranscoderException;
}

