/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.transcoder.image;

import io.sf.carte.echosvg.ext.awt.image.GraphicsUtil;
import io.sf.carte.echosvg.gvt.renderer.ConcreteImageRendererFactory;
import io.sf.carte.echosvg.gvt.renderer.ImageRenderer;
import io.sf.carte.echosvg.transcoder.TranscoderException;
import io.sf.carte.echosvg.transcoder.TranscoderOutput;
import io.sf.carte.echosvg.transcoder.TranscodingHints;
import io.sf.carte.echosvg.transcoder.keys.BooleanKey;
import io.sf.carte.echosvg.transcoder.keys.PaintKey;
import io.sf.carte.echosvg.transcoder.svg.SVGAbstractTranscoder;
import java.awt.AlphaComposite;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.awt.image.SinglePixelPackedSampleModel;
import org.w3c.dom.Document;

public abstract class ImageTranscoder
extends SVGAbstractTranscoder {
    public static final TranscodingHints.Key KEY_BACKGROUND_COLOR = new PaintKey();
    public static final TranscodingHints.Key KEY_FORCE_TRANSPARENT_WHITE = new BooleanKey();

    protected ImageTranscoder() {
    }

    @Override
    protected void transcode(Document document, String uri, TranscoderOutput output) throws TranscoderException {
        super.transcode(document, uri, output);
        int w = (int)(this.width + 0.5f);
        int h = (int)(this.height + 0.5f);
        ImageRenderer renderer = this.createRenderer();
        renderer.updateOffScreen(w, h);
        renderer.setTransform(this.getCurrentAOITransform());
        renderer.setTree(this.getCurrentGVTree());
        this.setCurrentGVTree(null);
        try {
            Rectangle2D.Float raoi = new Rectangle2D.Float(0.0f, 0.0f, this.width, this.height);
            renderer.repaint(this.getCurrentAOITransform().createInverse().createTransformedShape(raoi));
            BufferedImage rend = renderer.getOffScreen();
            renderer = null;
            BufferedImage dest = this.createImage(w, h);
            Graphics2D g2d = GraphicsUtil.createGraphics((BufferedImage)dest);
            if (this.hints.containsKey((Object)KEY_BACKGROUND_COLOR)) {
                Paint bgcolor = (Paint)this.hints.get((Object)KEY_BACKGROUND_COLOR);
                g2d.setComposite(AlphaComposite.SrcOver);
                g2d.setPaint(bgcolor);
                g2d.fillRect(0, 0, w, h);
            }
            if (rend != null) {
                g2d.drawRenderedImage(rend, new AffineTransform());
            }
            g2d.dispose();
            rend = null;
            this.writeImage(dest, output);
        }
        catch (Exception ex) {
            throw new TranscoderException(ex);
        }
    }

    protected ImageRenderer createRenderer() {
        ConcreteImageRendererFactory rendFactory = new ConcreteImageRendererFactory();
        return rendFactory.createStaticImageRenderer();
    }

    protected void forceTransparentWhite(BufferedImage img, SinglePixelPackedSampleModel sppsm) {
        int w = img.getWidth();
        int h = img.getHeight();
        DataBufferInt biDB = (DataBufferInt)img.getRaster().getDataBuffer();
        int scanStride = sppsm.getScanlineStride();
        int dbOffset = biDB.getOffset();
        int[] pixels = biDB.getBankData()[0];
        int p = dbOffset;
        int adjust = scanStride - w;
        int a = 0;
        int r = 0;
        int g = 0;
        int b = 0;
        int pel = 0;
        for (int i = 0; i < h; ++i) {
            for (int j = 0; j < w; ++j) {
                pel = pixels[p];
                a = pel >> 24 & 0xFF;
                r = pel >> 16 & 0xFF;
                g = pel >> 8 & 0xFF;
                b = pel & 0xFF;
                r = (255 * (255 - a) + a * r) / 255;
                g = (255 * (255 - a) + a * g) / 255;
                b = (255 * (255 - a) + a * b) / 255;
                pixels[p++] = a << 24 & 0xFF000000 | r << 16 & 0xFF0000 | g << 8 & 0xFF00 | b & 0xFF;
            }
            p += adjust;
        }
    }

    public abstract BufferedImage createImage(int var1, int var2);

    public abstract void writeImage(BufferedImage var1, TranscoderOutput var2) throws TranscoderException;
}

