/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.transcoder.image;

import io.sf.carte.echosvg.bridge.BridgeContext;
import io.sf.carte.echosvg.transcoder.TranscoderException;
import io.sf.carte.echosvg.transcoder.TranscoderOutput;
import io.sf.carte.echosvg.transcoder.TranscodingHints;
import io.sf.carte.echosvg.transcoder.image.ImageTranscoder;
import io.sf.carte.echosvg.transcoder.image.PNGTranscoderInternalCodecWriteAdapter;
import io.sf.carte.echosvg.transcoder.image.resources.Messages;
import io.sf.carte.echosvg.transcoder.keys.FloatKey;
import io.sf.carte.echosvg.transcoder.keys.IntegerKey;
import io.sf.carte.echosvg.transcoder.keys.StringArrayKey;
import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ComponentColorModel;
import java.awt.image.SinglePixelPackedSampleModel;
import java.awt.image.WritableRaster;
import java.io.OutputStream;

public class PNGTranscoder
extends ImageTranscoder {
    public static final TranscodingHints.Key KEY_GAMMA = new FloatKey();
    public static final float[] DEFAULT_CHROMA = new float[]{0.3127f, 0.329f, 0.64f, 0.33f, 0.3f, 0.6f, 0.15f, 0.06f};
    public static final TranscodingHints.Key KEY_COMPRESSION_LEVEL = new IntegerKey();
    public static final TranscodingHints.Key KEY_INDEXED = new IntegerKey();
    public static final TranscodingHints.Key KEY_KEYWORD_TEXT = new StringArrayKey();
    public static final TranscodingHints.Key KEY_INTERNATIONAL_TEXT = new StringArrayKey();
    public static final TranscodingHints.Key KEY_COMPRESSED_TEXT = new StringArrayKey();

    public PNGTranscoder() {
        this.hints.put(KEY_FORCE_TRANSPARENT_WHITE, (Object)Boolean.FALSE);
    }

    @Override
    public BufferedImage createImage(int width, int height) {
        BufferedImage image;
        ColorSpace space;
        BridgeContext ctx = this.getBridgeContext();
        if (ctx == null || (space = ctx.getColorSpace()) == null) {
            image = new BufferedImage(width, height, 2);
        } else {
            int[] bits = new int[]{16, 16, 16, 16};
            ComponentColorModel cm = new ComponentColorModel(space, bits, true, false, 3, 1);
            WritableRaster raster = cm.createCompatibleWritableRaster(width, height);
            image = new BufferedImage(cm, raster, false, null);
        }
        return image;
    }

    @Override
    public void writeImage(BufferedImage img, TranscoderOutput output) throws TranscoderException {
        OutputStream ostream = output.getOutputStream();
        if (ostream == null) {
            throw new TranscoderException(Messages.formatMessage("png.badoutput", null));
        }
        boolean forceTransparentWhite = false;
        if (this.hints.containsKey((Object)ImageTranscoder.KEY_FORCE_TRANSPARENT_WHITE)) {
            forceTransparentWhite = (Boolean)this.hints.get((Object)ImageTranscoder.KEY_FORCE_TRANSPARENT_WHITE);
        }
        if (forceTransparentWhite) {
            SinglePixelPackedSampleModel sppsm = (SinglePixelPackedSampleModel)img.getSampleModel();
            this.forceTransparentWhite(img, sppsm);
        }
        WriteAdapter adapter = this.createWriteAdapter();
        adapter.writeImage(this, img, output);
    }

    protected WriteAdapter createWriteAdapter() {
        return new PNGTranscoderInternalCodecWriteAdapter();
    }

    public static interface WriteAdapter {
        public void writeImage(PNGTranscoder var1, BufferedImage var2, TranscoderOutput var3) throws TranscoderException;
    }
}

