/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.transcoder.image;

import io.sf.carte.echosvg.ext.awt.image.GraphicsUtil;
import io.sf.carte.echosvg.ext.awt.image.rendered.FormatRed;
import io.sf.carte.echosvg.ext.awt.image.spi.ImageWriter;
import io.sf.carte.echosvg.ext.awt.image.spi.ImageWriterParams;
import io.sf.carte.echosvg.ext.awt.image.spi.ImageWriterRegistry;
import io.sf.carte.echosvg.transcoder.TranscoderException;
import io.sf.carte.echosvg.transcoder.TranscoderOutput;
import io.sf.carte.echosvg.transcoder.TranscodingHints;
import io.sf.carte.echosvg.transcoder.image.TIFFTranscoder;
import java.awt.image.BufferedImage;
import java.awt.image.PixelInterleavedSampleModel;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.SinglePixelPackedSampleModel;
import java.io.IOException;
import java.io.OutputStream;

class TIFFTranscoderImageIOWriteAdapter
implements TIFFTranscoder.WriteAdapter {
    TIFFTranscoderImageIOWriteAdapter() {
    }

    @Override
    public void writeImage(TIFFTranscoder transcoder, BufferedImage img, TranscoderOutput output) throws TranscoderException {
        TranscodingHints hints = transcoder.getTranscodingHints();
        ImageWriter writer = ImageWriterRegistry.getInstance().getWriterFor("image/tiff");
        ImageWriterParams params = new ImageWriterParams();
        float resol = transcoder.getUserAgent().getResolution();
        params.setResolution(Math.round(resol));
        if (hints.containsKey((Object)TIFFTranscoder.KEY_COMPRESSION_METHOD)) {
            String method = (String)hints.get((Object)TIFFTranscoder.KEY_COMPRESSION_METHOD);
            if ("packbits".equals(method)) {
                params.setCompressionMethod("PackBits");
            } else if ("deflate".equals(method)) {
                params.setCompressionMethod("Deflate");
            } else if ("lzw".equals(method)) {
                params.setCompressionMethod("LZW");
            } else if ("jpeg".equals(method)) {
                params.setCompressionMethod("JPEG");
            }
        }
        try {
            OutputStream ostream = output.getOutputStream();
            int w = img.getWidth();
            int h = img.getHeight();
            SinglePixelPackedSampleModel sppsm = (SinglePixelPackedSampleModel)img.getSampleModel();
            int bands = sppsm.getNumBands();
            int[] off = new int[bands];
            for (int i = 0; i < bands; ++i) {
                off[i] = i;
            }
            PixelInterleavedSampleModel sm = new PixelInterleavedSampleModel(0, w, h, bands, w * bands, off);
            FormatRed rimg = new FormatRed(GraphicsUtil.wrap((RenderedImage)img), (SampleModel)sm);
            writer.writeImage((RenderedImage)rimg, ostream, params);
            ostream.flush();
        }
        catch (IOException ex) {
            throw new TranscoderException((Exception)ex);
        }
    }
}

