/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.transcoder.impl;

import io.sf.carte.doc.style.css.CSSExpressionValue;
import io.sf.carte.doc.style.css.CSSTypedValue;
import io.sf.carte.doc.style.css.CSSValue;
import io.sf.carte.doc.style.css.property.Evaluator;
import io.sf.carte.doc.style.css.property.StyleValue;
import io.sf.carte.doc.style.css.property.ValueFactory;
import io.sf.carte.doc.style.css.property.ValueList;
import io.sf.carte.echosvg.transcoder.TranscoderException;
import org.w3c.css.om.unit.CSSUnit;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;

public class SizingHelper {
    private SizingHelper() {
    }

    public static void defaultDimensions(Element svgRoot) {
        String viewBox;
        String width = svgRoot.getAttribute("width").trim();
        String height = svgRoot.getAttribute("height").trim();
        if (width.isEmpty() || "auto".equalsIgnoreCase(width)) {
            SizingHelper.defaultWidth(svgRoot, height);
        }
        if ((height.isEmpty() || "auto".equalsIgnoreCase(height)) && (viewBox = svgRoot.getAttribute("viewBox").trim()).isEmpty()) {
            svgRoot.setAttribute("height", "150px");
        }
    }

    private static void defaultWidth(Element svgRoot, String height) {
        String width;
        String viewBox = svgRoot.getAttribute("viewBox").trim();
        if (viewBox.isEmpty()) {
            width = "300px";
        } else if (!height.isEmpty() && !"auto".equalsIgnoreCase(height)) {
            try {
                float ratio = SizingHelper.computeAspectRatio(viewBox);
                float fh = SizingHelper.floatValue(height);
                if (!Float.isNaN(ratio) && !Float.isNaN(fh)) {
                    width = Float.toString(ratio * fh);
                }
                width = "300px";
            }
            catch (TranscoderException e) {
                return;
            }
            catch (Exception e) {
                width = "300px";
            }
        } else {
            return;
        }
        svgRoot.setAttribute("width", width);
    }

    static float computeAspectRatio(String viewBox) throws DOMException {
        float[] numbers;
        ValueFactory factory = new ValueFactory();
        StyleValue value = factory.parseProperty(viewBox);
        if (!SizingHelper.computeRectangle(value, numbers = new float[4])) {
            throw new DOMException(12, "Wrong viewBox attribute.");
        }
        return numbers[2] / numbers[3];
    }

    static boolean computeRectangle(StyleValue value, float[] numbers) throws DOMException {
        if (value.getCssValueType() != CSSValue.CssType.LIST) {
            return false;
        }
        ValueList list = (ValueList)value;
        if (list.getLength() != 4) {
            return false;
        }
        for (int i = 0; i < 4; ++i) {
            CSSTypedValue typed;
            StyleValue item = list.item(i);
            if (item.getCssValueType() != CSSValue.CssType.TYPED) {
                return false;
            }
            switch (item.getPrimitiveType()) {
                case NUMERIC: {
                    typed = (CSSTypedValue)item;
                    if (typed.getUnitType() == 0) break;
                    return false;
                }
                case EXPRESSION: {
                    Evaluator eval = new Evaluator(0);
                    typed = eval.evaluateExpression((CSSExpressionValue)item);
                    if (typed.getUnitType() == 0) break;
                    return false;
                }
                default: {
                    return false;
                }
            }
            numbers[i] = typed.getFloatValue((short)0);
        }
        return true;
    }

    static float floatValue(String number) throws TranscoderException, DOMException {
        CSSTypedValue typed;
        ValueFactory factory = new ValueFactory();
        StyleValue value = factory.parseProperty(number);
        if (value.getCssValueType() != CSSValue.CssType.TYPED) {
            throw new TranscoderException("Leave value unchanged.");
        }
        switch (value.getPrimitiveType()) {
            case NUMERIC: {
                typed = (CSSTypedValue)value;
                if (typed.getUnitType() == 0) break;
                if (CSSUnit.isRelativeLengthUnitType((short)typed.getUnitType())) {
                    throw new TranscoderException("Leave value unchanged.");
                }
                return typed.getFloatValue((short)3);
            }
            case EXPRESSION: {
                Evaluator eval = new Evaluator(0);
                typed = eval.evaluateExpression((CSSExpressionValue)value);
                if (typed.getUnitType() == 0) break;
                if (CSSUnit.isRelativeLengthUnitType((short)typed.getUnitType())) {
                    throw new TranscoderException("Leave value unchanged.");
                }
                return typed.getFloatValue((short)3);
            }
            default: {
                throw new DOMException(12, "Wrong dimension.");
            }
        }
        return typed.getFloatValue((short)0);
    }
}

