/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.transcoder.image;

import io.sf.carte.echosvg.ext.awt.image.rendered.IndexImage;
import io.sf.carte.echosvg.ext.awt.image.spi.ImageWriter;
import io.sf.carte.echosvg.ext.awt.image.spi.ImageWriterParams;
import io.sf.carte.echosvg.ext.awt.image.spi.ImageWriterRegistry;
import io.sf.carte.echosvg.ext.awt.image.spi.PNGImageWriterParams;
import io.sf.carte.echosvg.transcoder.TranscoderException;
import io.sf.carte.echosvg.transcoder.TranscoderOutput;
import io.sf.carte.echosvg.transcoder.TranscodingHints;
import io.sf.carte.echosvg.transcoder.image.PNGTranscoder;
import io.sf.carte.echosvg.transcoder.impl.ColorHelper;
import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.OutputStream;

public class PNGTranscoderImageIOWriteAdapter
implements PNGTranscoder.WriteAdapter {
    @Override
    public void writeImage(PNGTranscoder transcoder, BufferedImage img, TranscoderOutput output) throws TranscoderException {
        String[] text;
        Integer level;
        float gamma;
        TranscodingHints hints = transcoder.getTranscodingHints();
        int n = -1;
        if (hints.containsKey((Object)PNGTranscoder.KEY_INDEXED) && ((n = ((Integer)hints.get((Object)PNGTranscoder.KEY_INDEXED)).intValue()) == 1 || n == 2 || n == 4 || n == 8)) {
            img = IndexImage.getIndexedImage((BufferedImage)img, (int)(1 << n));
        }
        ImageWriter writer = ImageWriterRegistry.getInstance().getWriterFor("image/png");
        PNGImageWriterParams params = new PNGImageWriterParams();
        if (hints.containsKey((Object)PNGTranscoder.KEY_GAMMA) && (gamma = ((Float)hints.get((Object)PNGTranscoder.KEY_GAMMA)).floatValue()) > 0.0f) {
            params.setGamma(gamma);
            ColorSpace cs = img.getColorModel().getColorSpace();
            params.setChromaticity(ColorHelper.defaultChromaticity(cs));
        }
        if ((level = (Integer)hints.get((Object)PNGTranscoder.KEY_COMPRESSION_LEVEL)) != null) {
            params.setCompressionLevel(level.intValue());
        }
        if ((text = (String[])hints.get((Object)PNGTranscoder.KEY_KEYWORD_TEXT)) != null) {
            params.setText(text);
        }
        if ((text = (String[])hints.get((Object)PNGTranscoder.KEY_INTERNATIONAL_TEXT)) != null) {
            params.setInternationalText(text);
        }
        if ((text = (String[])hints.get((Object)PNGTranscoder.KEY_COMPRESSED_TEXT)) != null) {
            params.setCompressedText(text);
        }
        float resol = transcoder.getUserAgent().getResolution();
        params.setResolution(Math.round(resol));
        try {
            OutputStream ostream = output.getOutputStream();
            writer.writeImage((RenderedImage)img, ostream, (ImageWriterParams)params);
            ostream.flush();
        }
        catch (IOException ex) {
            throw new TranscoderException((Exception)ex);
        }
    }
}

