/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.transcoder.svg;

import io.sf.carte.echosvg.anim.dom.SAXSVGDocumentFactory;
import io.sf.carte.echosvg.anim.dom.SVG12DOMImplementation;
import io.sf.carte.echosvg.anim.dom.SVGDOMImplementation;
import io.sf.carte.echosvg.anim.dom.SVGOMDocument;
import io.sf.carte.echosvg.bridge.BaseScriptingEnvironment;
import io.sf.carte.echosvg.bridge.BridgeContext;
import io.sf.carte.echosvg.bridge.BridgeException;
import io.sf.carte.echosvg.bridge.DefaultScriptSecurity;
import io.sf.carte.echosvg.bridge.ExternalResourceSecurity;
import io.sf.carte.echosvg.bridge.GVTBuilder;
import io.sf.carte.echosvg.bridge.NoLoadScriptSecurity;
import io.sf.carte.echosvg.bridge.RelaxedExternalResourceSecurity;
import io.sf.carte.echosvg.bridge.RelaxedScriptSecurity;
import io.sf.carte.echosvg.bridge.SVGUtilities;
import io.sf.carte.echosvg.bridge.ScriptSecurity;
import io.sf.carte.echosvg.bridge.UserAgent;
import io.sf.carte.echosvg.bridge.UserAgentAdapter;
import io.sf.carte.echosvg.bridge.ViewBox;
import io.sf.carte.echosvg.bridge.svg12.SVG12BridgeContext;
import io.sf.carte.echosvg.dom.AbstractParentNode;
import io.sf.carte.echosvg.dom.util.DocumentFactory;
import io.sf.carte.echosvg.gvt.CanvasGraphicsNode;
import io.sf.carte.echosvg.gvt.CompositeGraphicsNode;
import io.sf.carte.echosvg.gvt.GraphicsNode;
import io.sf.carte.echosvg.transcoder.TranscoderException;
import io.sf.carte.echosvg.transcoder.TranscoderInput;
import io.sf.carte.echosvg.transcoder.TranscoderOutput;
import io.sf.carte.echosvg.transcoder.XMLAbstractTranscoder;
import io.sf.carte.echosvg.transcoder.impl.SizingHelper;
import io.sf.carte.echosvg.util.ParsedURL;
import java.awt.Dimension;
import java.awt.geom.AffineTransform;
import java.awt.geom.Dimension2D;
import java.awt.geom.Rectangle2D;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class SVGAbstractTranscoder
extends io.sf.carte.echosvg.transcoder.SVGAbstractTranscoder {
    private GraphicsNode root;
    private BridgeContext ctx;
    private GVTBuilder builder;
    private UserAgent userAgent = this.createUserAgent();

    protected SVGAbstractTranscoder() {
    }

    protected UserAgent createUserAgent() {
        return new SVGAbstractTranscoderUserAgent();
    }

    protected BridgeContext getBridgeContext() {
        return this.ctx;
    }

    protected void setBridgeContext(BridgeContext ctx) {
        this.ctx = ctx;
    }

    protected GraphicsNode getCurrentGVTree() {
        return this.root;
    }

    protected void setCurrentGVTree(GraphicsNode root) {
        this.root = root;
    }

    public UserAgent getUserAgent() {
        return this.userAgent;
    }

    protected DocumentFactory createSVGDocumentFactory() {
        return new SAXSVGDocumentFactory();
    }

    public void transcode(TranscoderInput input, TranscoderOutput output) throws TranscoderException {
        super.transcode(input, output);
        if (this.ctx != null) {
            this.ctx.dispose();
        }
    }

    protected void transcode(Document document, String uri, TranscoderOutput output) throws TranscoderException {
        AffineTransform Px;
        GraphicsNode gvtRoot;
        Element root = document.getDocumentElement();
        SVGOMDocument svgDoc = !(document instanceof SVGOMDocument) || root.getNamespaceURI() != "http://www.w3.org/2000/svg" ? this.importAsSVGDocument(document, uri) : (SVGOMDocument)document;
        if (svgDoc == null) {
            throw new TranscoderException("Document contains no valid SVG element.");
        }
        if (this.hints.containsKey((Object)KEY_WIDTH)) {
            this.width = ((Float)this.hints.get((Object)KEY_WIDTH)).floatValue();
        }
        if (this.hints.containsKey((Object)KEY_HEIGHT)) {
            this.height = ((Float)this.hints.get((Object)KEY_HEIGHT)).floatValue();
        }
        this.ctx = this.createBridgeContext(svgDoc);
        this.builder = new GVTBuilder();
        boolean isDynamic = this.hints.containsKey((Object)KEY_EXECUTE_ONLOAD) && (Boolean)this.hints.get((Object)KEY_EXECUTE_ONLOAD) != false;
        try {
            if (isDynamic) {
                this.ctx.setDynamicState(2);
            }
            if ((gvtRoot = this.builder.build(this.ctx, (Document)svgDoc)) == null) {
                throw new TranscoderException("Could not build a bridge for the document at uri " + Objects.toString(uri, "<unknown>"));
            }
            if (this.ctx.isDynamic()) {
                float t;
                BaseScriptingEnvironment se = new BaseScriptingEnvironment(this.ctx);
                se.loadScripts();
                se.dispatchSVGLoadEvent();
                if (this.hints.containsKey((Object)KEY_SNAPSHOT_TIME)) {
                    t = ((Float)this.hints.get((Object)KEY_SNAPSHOT_TIME)).floatValue();
                    this.ctx.getAnimationEngine().setCurrentTime(t);
                } else if (this.ctx.isSVG12()) {
                    t = SVGUtilities.convertSnapshotTime((Element)root, null);
                    this.ctx.getAnimationEngine().setCurrentTime(t);
                }
            }
        }
        catch (BridgeException ex) {
            try {
                this.ctx.close();
            }
            catch (RuntimeException t) {
                // empty catch block
            }
            throw new TranscoderException((Exception)((Object)ex));
        }
        float docWidth = (float)this.ctx.getDocumentSize().getWidth();
        float docHeight = (float)this.ctx.getDocumentSize().getHeight();
        this.setImageSize(docWidth, docHeight);
        if (this.hints.containsKey((Object)KEY_AOI)) {
            Rectangle2D aoi = (Rectangle2D)this.hints.get((Object)KEY_AOI);
            Px = new AffineTransform();
            double sx = (double)this.width / aoi.getWidth();
            double sy = (double)this.height / aoi.getHeight();
            double scale = Math.min(sx, sy);
            Px.scale(scale, scale);
            double tx = -aoi.getX() + ((double)this.width / scale - aoi.getWidth()) / 2.0;
            double ty = -aoi.getY() + ((double)this.height / scale - aoi.getHeight()) / 2.0;
            Px.translate(tx, ty);
            this.setCurrentAOI(aoi);
        } else {
            String ref = new ParsedURL(uri).getRef();
            String viewBox = root.getAttributeNS(null, "viewBox").trim();
            if (ref != null && !ref.isEmpty()) {
                Px = ViewBox.getViewTransform((String)ref, (Element)root, (float)this.width, (float)this.height, (BridgeContext)this.ctx);
            } else if (!viewBox.isEmpty()) {
                String aspectRatio = root.getAttributeNS(null, "preserveAspectRatio");
                Px = ViewBox.getPreserveAspectRatioTransform((Element)root, (String)viewBox, (String)aspectRatio, (float)this.width, (float)this.height, (BridgeContext)this.ctx);
                if (Px == null) {
                    Px = AffineTransform.getTranslateInstance(Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY);
                }
            } else {
                float xscale = this.width / docWidth;
                float yscale = this.height / docHeight;
                float scale = Math.min(xscale, yscale);
                Px = AffineTransform.getScaleInstance(scale, scale);
            }
            this.setCurrentAOI(new Rectangle2D.Float(0.0f, 0.0f, this.width, this.height));
        }
        CanvasGraphicsNode cgn = this.getCanvasGraphicsNode(gvtRoot);
        if (cgn != null) {
            cgn.setViewingTransform(Px);
            this.setCurrentAOITransform(new AffineTransform());
        } else {
            this.setCurrentAOITransform(Px);
        }
        this.root = gvtRoot;
    }

    private SVGOMDocument importAsSVGDocument(Document document, String uri) throws TranscoderException {
        DOMImplementation impl;
        Element docElm = document.getDocumentElement();
        if (!"http://www.w3.org/2000/svg".equals(docElm.getNamespaceURI()) && !"svg".equalsIgnoreCase(docElm.getTagName())) {
            String selector = (String)this.hints.get((Object)KEY_SVG_SELECTOR);
            if (selector != null && !(selector = selector.trim()).isEmpty()) {
                try {
                    docElm = ((AbstractParentNode)docElm).querySelector(selector);
                }
                catch (DOMException e) {
                    throw new TranscoderException("Invalid selector: " + selector + '.', (Exception)e);
                }
                if (docElm == null || !"svg".equals(docElm.getLocalName()) && !"svg".equals(docElm.getTagName())) {
                    throw new TranscoderException("Selector " + selector + " points to no valid SVG element.");
                }
                String namespaceURI = docElm.getNamespaceURI();
                if (namespaceURI == null) {
                    docElm = this.replaceSVGRoot(docElm);
                } else if (!"http://www.w3.org/2000/svg".equals(namespaceURI)) {
                    throw new TranscoderException("Selector " + selector + " points to element in " + namespaceURI + " namespace.");
                }
            } else {
                docElm = (Element)document.getElementsByTagNameNS("http://www.w3.org/2000/svg", "svg").item(0);
                if (docElm == null) {
                    if (document.getDocumentElement().getNamespaceURI() != null) {
                        return null;
                    }
                    docElm = (Element)document.getElementsByTagName("svg").item(0);
                    if (docElm == null) {
                        return null;
                    }
                    docElm = this.replaceSVGRoot(docElm);
                } else {
                    SizingHelper.defaultDimensions(docElm);
                }
            }
        }
        if ((impl = (DOMImplementation)this.hints.get((Object)KEY_DOM_IMPLEMENTATION)) == null) {
            impl = "1.2".equals(docElm.getAttribute("version")) ? SVG12DOMImplementation.getDOMImplementation() : SVGDOMImplementation.getDOMImplementation();
        }
        SVGOMDocument svgDocument = (SVGOMDocument)SVGAbstractTranscoder.deepCloneDocument(document, docElm, impl);
        if (uri != null) {
            ParsedURL url = new ParsedURL(uri);
            svgDocument.setParsedURL(url);
        }
        return svgDocument;
    }

    private Element replaceSVGRoot(Element docElm) {
        docElm.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", "http://www.w3.org/2000/svg");
        Element newRoot = this.replaceNamespace(docElm);
        docElm.getParentNode().replaceChild(newRoot, docElm);
        SizingHelper.defaultDimensions(newRoot);
        return newRoot;
    }

    private Element replaceNamespace(Element elm) {
        Element svgElm;
        block7: {
            block6: {
                Node node;
                if (elm.getNamespaceURI() != null) break block6;
                svgElm = elm.getOwnerDocument().createElementNS("http://www.w3.org/2000/svg", elm.getTagName());
                if (elm.hasAttributes()) {
                    NamedNodeMap attrMap = elm.getAttributes();
                    for (int i = 0; i < attrMap.getLength(); ++i) {
                        Node attr = attrMap.item(i);
                        svgElm.setAttributeNode((Attr)attr.cloneNode(true));
                    }
                }
                if (!elm.hasChildNodes()) break block7;
                NodeList nodeList = elm.getChildNodes();
                int i = 0;
                while ((node = nodeList.item(i)) != null) {
                    Element newNode;
                    if (node.getNodeType() == 1 && (newNode = this.replaceNamespace((Element)node)) != node) {
                        ++i;
                        node = newNode;
                    }
                    svgElm.appendChild(node);
                }
                break block7;
            }
            svgElm = elm;
            if (elm.hasChildNodes()) {
                NodeList nodeList = elm.getChildNodes();
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    Element newNode;
                    Node node = nodeList.item(i);
                    if (node.getNodeType() != 1 || (newNode = this.replaceNamespace((Element)node)) == node) continue;
                    elm.replaceChild(newNode, node);
                }
            }
        }
        return svgElm;
    }

    private static Document deepCloneDocument(Document doc, Element root, DOMImplementation impl) {
        Node firstNode;
        boolean before;
        Document result = impl.createDocument(root.getNamespaceURI(), root.getNodeName(), null);
        Element rroot = result.getDocumentElement();
        boolean bl = before = root.getParentNode().getNodeType() == 9;
        if (before) {
            firstNode = doc.getFirstChild();
        } else {
            firstNode = root;
            SVGAbstractTranscoder.appendHeadStyleElements(doc, result, rroot);
        }
        for (Node n = firstNode; n != null; n = n.getNextSibling()) {
            if (n == root) {
                before = false;
                if (root.hasAttributes()) {
                    NamedNodeMap attr = root.getAttributes();
                    int len = attr.getLength();
                    for (int i = 0; i < len; ++i) {
                        rroot.setAttributeNode((Attr)result.importNode(attr.item(i), true));
                    }
                }
                for (Node c = root.getFirstChild(); c != null; c = c.getNextSibling()) {
                    rroot.appendChild(result.importNode(c, true));
                }
                continue;
            }
            short type = n.getNodeType();
            if (type != 10 && type != 8 && type != 7) continue;
            if (before) {
                result.insertBefore(result.importNode(n, true), rroot);
                continue;
            }
            result.appendChild(result.importNode(n, true));
        }
        return result;
    }

    private static void appendHeadStyleElements(Document doc, Document result, Element rroot) {
        Element docElm = doc.getDocumentElement();
        for (Node n = docElm.getFirstChild(); n != null; n = n.getNextSibling()) {
            if (n.getNodeType() != 1 || !"head".equals(n.getNodeName()) && !"head".equals(n.getLocalName())) continue;
            Element head = (Element)n;
            NodeList styleList = docElm.getNamespaceURI() != null ? head.getElementsByTagNameNS("*", "style") : head.getElementsByTagName("style");
            int len = styleList.getLength();
            for (int i = 0; i < len; ++i) {
                Node style = styleList.item(i);
                NamedNodeMap attr = style.getAttributes();
                String qname = "style";
                String pre = rroot.getPrefix();
                if (pre != null) {
                    qname = pre + ':' + qname;
                }
                Element rstyle = result.createElementNS("http://www.w3.org/2000/svg", qname);
                int attrLen = attr.getLength();
                for (int j = 0; j < attrLen; ++j) {
                    rstyle.setAttributeNode((Attr)result.importNode(attr.item(j), true));
                }
                rstyle.setTextContent(style.getTextContent());
                rroot.appendChild(rstyle);
            }
            break;
        }
    }

    protected CanvasGraphicsNode getCanvasGraphicsNode(GraphicsNode gn) {
        if (!(gn instanceof CompositeGraphicsNode)) {
            return null;
        }
        CompositeGraphicsNode cgn = (CompositeGraphicsNode)gn;
        List children = cgn.getChildren();
        if (children.isEmpty()) {
            return null;
        }
        gn = (GraphicsNode)children.get(0);
        if (!(gn instanceof CanvasGraphicsNode)) {
            return null;
        }
        return (CanvasGraphicsNode)gn;
    }

    protected BridgeContext createBridgeContext(SVGOMDocument doc) {
        return doc.isSVG12() ? this.createSVG12BridgeContext() : this.createBridgeContext();
    }

    protected BridgeContext createBridgeContext() {
        return new BridgeContext(this.userAgent);
    }

    @Deprecated
    protected final BridgeContext createBridgeContext(String svgVersion) {
        if ("1.2".equals(svgVersion)) {
            return this.createSVG12BridgeContext();
        }
        return this.createBridgeContext();
    }

    protected BridgeContext createSVG12BridgeContext() {
        return new SVG12BridgeContext(this.userAgent);
    }

    protected void setImageSize(float docWidth, float docHeight) {
        float imgWidth = -1.0f;
        if (this.hints.containsKey((Object)KEY_WIDTH)) {
            imgWidth = ((Float)this.hints.get((Object)KEY_WIDTH)).floatValue();
        }
        float imgHeight = -1.0f;
        if (this.hints.containsKey((Object)KEY_HEIGHT)) {
            imgHeight = ((Float)this.hints.get((Object)KEY_HEIGHT)).floatValue();
        }
        if (imgWidth > 0.0f && imgHeight > 0.0f) {
            this.width = imgWidth;
            this.height = imgHeight;
        } else if (imgHeight > 0.0f) {
            this.width = docWidth * imgHeight / docHeight;
            this.height = imgHeight;
        } else if (imgWidth > 0.0f) {
            this.width = imgWidth;
            this.height = docHeight * imgWidth / docWidth;
        } else {
            this.width = docWidth;
            this.height = docHeight;
        }
        float imgMaxWidth = -1.0f;
        if (this.hints.containsKey((Object)KEY_MAX_WIDTH)) {
            imgMaxWidth = ((Float)this.hints.get((Object)KEY_MAX_WIDTH)).floatValue();
        }
        float imgMaxHeight = -1.0f;
        if (this.hints.containsKey((Object)KEY_MAX_HEIGHT)) {
            imgMaxHeight = ((Float)this.hints.get((Object)KEY_MAX_HEIGHT)).floatValue();
        }
        if (imgMaxHeight > 0.0f && this.height > imgMaxHeight) {
            this.width = docWidth * imgMaxHeight / docHeight;
            this.height = imgMaxHeight;
        }
        if (imgMaxWidth > 0.0f && this.width > imgMaxWidth) {
            this.width = imgMaxWidth;
            this.height = docHeight * imgMaxWidth / docWidth;
        }
    }

    protected class SVGAbstractTranscoderUserAgent
    extends UserAgentAdapter {
        protected List<String> scripts;

        public SVGAbstractTranscoderUserAgent() {
            this.addStdFeatures();
        }

        public AffineTransform getTransform() {
            return SVGAbstractTranscoder.this.getCurrentAOITransform();
        }

        public void setTransform(AffineTransform at) {
            SVGAbstractTranscoder.this.setCurrentAOITransform(at);
        }

        public Dimension2D getViewportSize() {
            return new Dimension((int)SVGAbstractTranscoder.this.width, (int)SVGAbstractTranscoder.this.height);
        }

        public void displayError(String message) {
            try {
                SVGAbstractTranscoder.this.handler.error(new TranscoderException(message));
            }
            catch (TranscoderException ex) {
                throw new RuntimeException(ex.getMessage());
            }
        }

        public void displayError(Exception e) {
            try {
                SVGAbstractTranscoder.this.handler.error(new TranscoderException(e));
            }
            catch (TranscoderException ex) {
                throw new RuntimeException(ex);
            }
        }

        public void displayMessage(String message) {
            try {
                SVGAbstractTranscoder.this.handler.warning(new TranscoderException(message));
            }
            catch (TranscoderException ex) {
                throw new RuntimeException(ex.getMessage());
            }
        }

        public float getPixelUnitToMillimeter() {
            Object obj = SVGAbstractTranscoder.this.hints.get((Object)io.sf.carte.echosvg.transcoder.SVGAbstractTranscoder.KEY_PIXEL_UNIT_TO_MILLIMETER);
            if (obj != null) {
                return ((Float)obj).floatValue();
            }
            obj = SVGAbstractTranscoder.this.hints.get((Object)io.sf.carte.echosvg.transcoder.SVGAbstractTranscoder.KEY_RESOLUTION_DPI);
            if (obj != null) {
                return 25.4f / ((Float)obj).floatValue();
            }
            return super.getPixelUnitToMillimeter();
        }

        public float getResolution() {
            Float obj = (Float)SVGAbstractTranscoder.this.hints.get((Object)io.sf.carte.echosvg.transcoder.SVGAbstractTranscoder.KEY_RESOLUTION_DPI);
            if (obj != null) {
                return obj.floatValue();
            }
            Float deprec = (Float)SVGAbstractTranscoder.this.hints.get((Object)io.sf.carte.echosvg.transcoder.SVGAbstractTranscoder.KEY_PIXEL_UNIT_TO_MILLIMETER);
            if (deprec != null) {
                return 25.4f / deprec.floatValue();
            }
            return 96.0f;
        }

        public String getLanguages() {
            if (SVGAbstractTranscoder.this.hints.containsKey((Object)io.sf.carte.echosvg.transcoder.SVGAbstractTranscoder.KEY_LANGUAGE)) {
                return (String)SVGAbstractTranscoder.this.hints.get((Object)io.sf.carte.echosvg.transcoder.SVGAbstractTranscoder.KEY_LANGUAGE);
            }
            return super.getLanguages();
        }

        public String getMedia() {
            String s = (String)SVGAbstractTranscoder.this.hints.get((Object)io.sf.carte.echosvg.transcoder.SVGAbstractTranscoder.KEY_MEDIA);
            if (s != null) {
                return s;
            }
            return super.getMedia();
        }

        public String getPrefersColorScheme() {
            String s = (String)SVGAbstractTranscoder.this.hints.get((Object)io.sf.carte.echosvg.transcoder.SVGAbstractTranscoder.KEY_PREFERS_COLOR_SCHEME);
            if (s != null) {
                return s;
            }
            return super.getPrefersColorScheme();
        }

        public String getDefaultFontFamily() {
            String s = (String)SVGAbstractTranscoder.this.hints.get((Object)io.sf.carte.echosvg.transcoder.SVGAbstractTranscoder.KEY_DEFAULT_FONT_FAMILY);
            if (s != null) {
                return s;
            }
            return super.getDefaultFontFamily();
        }

        public String getAlternateStyleSheet() {
            String s = (String)SVGAbstractTranscoder.this.hints.get((Object)io.sf.carte.echosvg.transcoder.SVGAbstractTranscoder.KEY_ALTERNATE_STYLESHEET);
            if (s != null) {
                return s;
            }
            return super.getAlternateStyleSheet();
        }

        public String getUserStyleSheetURI() {
            String s = (String)SVGAbstractTranscoder.this.hints.get((Object)io.sf.carte.echosvg.transcoder.SVGAbstractTranscoder.KEY_USER_STYLESHEET_URI);
            if (s != null) {
                return s;
            }
            return super.getUserStyleSheetURI();
        }

        public boolean isXMLParserValidating() {
            Boolean b = (Boolean)SVGAbstractTranscoder.this.hints.get((Object)XMLAbstractTranscoder.KEY_XML_PARSER_VALIDATING);
            if (b != null) {
                return b;
            }
            return super.isXMLParserValidating();
        }

        public ScriptSecurity getScriptSecurity(String scriptType, ParsedURL scriptPURL, ParsedURL docPURL) {
            if (this.scripts == null) {
                this.computeAllowedScripts();
            }
            if (!this.scripts.contains(scriptType)) {
                return new NoLoadScriptSecurity(scriptType);
            }
            boolean constrainOrigin = true;
            if (SVGAbstractTranscoder.this.hints.containsKey((Object)io.sf.carte.echosvg.transcoder.SVGAbstractTranscoder.KEY_CONSTRAIN_SCRIPT_ORIGIN)) {
                constrainOrigin = (Boolean)SVGAbstractTranscoder.this.hints.get((Object)io.sf.carte.echosvg.transcoder.SVGAbstractTranscoder.KEY_CONSTRAIN_SCRIPT_ORIGIN);
            }
            if (constrainOrigin) {
                return new DefaultScriptSecurity(scriptType, scriptPURL, docPURL);
            }
            return new RelaxedScriptSecurity(scriptType, scriptPURL, docPURL);
        }

        protected void computeAllowedScripts() {
            if (!SVGAbstractTranscoder.this.hints.containsKey((Object)io.sf.carte.echosvg.transcoder.SVGAbstractTranscoder.KEY_ALLOWED_SCRIPT_TYPES)) {
                this.scripts = Collections.emptyList();
                return;
            }
            String allowedScripts = (String)SVGAbstractTranscoder.this.hints.get((Object)io.sf.carte.echosvg.transcoder.SVGAbstractTranscoder.KEY_ALLOWED_SCRIPT_TYPES);
            this.scripts = Arrays.asList(allowedScripts.split(", "));
        }

        public ExternalResourceSecurity getExternalResourceSecurity(ParsedURL resourceURL, ParsedURL docURL) {
            if (this.isAllowExternalResources()) {
                return new RelaxedExternalResourceSecurity(resourceURL, docURL);
            }
            return super.getExternalResourceSecurity(resourceURL, docURL);
        }

        public boolean isAllowExternalResources() {
            Boolean b = (Boolean)SVGAbstractTranscoder.this.hints.get((Object)io.sf.carte.echosvg.transcoder.SVGAbstractTranscoder.KEY_ALLOW_EXTERNAL_RESOURCES);
            if (b != null) {
                return b;
            }
            return false;
        }
    }
}

