/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.transcoder.util;

import io.sf.carte.doc.agent.DeviceFactory;
import io.sf.carte.doc.dom.CSSDOMImplementation;
import io.sf.carte.doc.dom.DOMDocument;
import io.sf.carte.doc.dom.DOMElement;
import io.sf.carte.doc.dom.DOMNode;
import io.sf.carte.doc.dom.XMLDocumentBuilder;
import io.sf.carte.doc.style.css.BoxValues;
import io.sf.carte.doc.style.css.CSSCanvas;
import io.sf.carte.doc.style.css.CSSColor;
import io.sf.carte.doc.style.css.CSSColorMixFunction;
import io.sf.carte.doc.style.css.CSSColorValue;
import io.sf.carte.doc.style.css.CSSComputedProperties;
import io.sf.carte.doc.style.css.CSSDocument;
import io.sf.carte.doc.style.css.CSSMediaException;
import io.sf.carte.doc.style.css.CSSStyleDeclaration;
import io.sf.carte.doc.style.css.CSSTypedValue;
import io.sf.carte.doc.style.css.CSSValue;
import io.sf.carte.doc.style.css.DeclarationFormattingContext;
import io.sf.carte.doc.style.css.RGBAColor;
import io.sf.carte.doc.style.css.StyleDatabase;
import io.sf.carte.doc.style.css.StyleFormattingContext;
import io.sf.carte.doc.style.css.StyleFormattingFactory;
import io.sf.carte.doc.style.css.awt.AWTHelper;
import io.sf.carte.doc.style.css.nsac.ArgumentCondition;
import io.sf.carte.doc.style.css.nsac.CombinatorCondition;
import io.sf.carte.doc.style.css.nsac.CombinatorSelector;
import io.sf.carte.doc.style.css.nsac.Condition;
import io.sf.carte.doc.style.css.nsac.ConditionalSelector;
import io.sf.carte.doc.style.css.nsac.LexicalUnit;
import io.sf.carte.doc.style.css.nsac.Selector;
import io.sf.carte.doc.style.css.nsac.SelectorList;
import io.sf.carte.doc.style.css.om.AbstractCSSCanvas;
import io.sf.carte.doc.style.css.om.AbstractStyleDatabase;
import io.sf.carte.doc.style.css.om.ColorDeclarationFormattingContext;
import io.sf.carte.doc.style.css.om.ComputedCSSStyle;
import io.sf.carte.doc.style.css.om.DefaultStyleFormattingContext;
import io.sf.carte.doc.style.css.property.ColorIdentifiers;
import io.sf.carte.doc.style.css.property.NumberValue;
import io.sf.carte.doc.style.css.property.StyleValue;
import io.sf.carte.doc.style.css.property.ValueFactory;
import io.sf.carte.doc.xml.dtd.DefaultEntityResolver;
import io.sf.carte.echosvg.anim.dom.SVG12DOMImplementation;
import io.sf.carte.echosvg.anim.dom.SVGDOMImplementation;
import io.sf.carte.echosvg.transcoder.DefaultErrorHandler;
import io.sf.carte.echosvg.transcoder.ErrorHandler;
import io.sf.carte.echosvg.transcoder.SVGAbstractTranscoder;
import io.sf.carte.echosvg.transcoder.Transcoder;
import io.sf.carte.echosvg.transcoder.TranscoderException;
import io.sf.carte.echosvg.transcoder.TranscoderInput;
import io.sf.carte.echosvg.transcoder.TranscoderOutput;
import io.sf.carte.echosvg.transcoder.TranscodingHints;
import io.sf.carte.echosvg.transcoder.image.ImageTranscoder;
import io.sf.carte.echosvg.transcoder.image.PNGTranscoder;
import io.sf.carte.echosvg.transcoder.impl.SizingHelper;
import io.sf.carte.echosvg.util.ParsedURL;
import io.sf.carte.util.SimpleWriter;
import io.sf.carte.util.agent.AgentUtil;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.w3c.css.om.unit.CSSUnit;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class CSSTranscodingHelper {
    private static final Set<String> noStyle;
    private final Transcoder transcoder;
    private static final CSSTypedValue darkmodeInitialColor;
    private boolean htmlEmbed = false;
    private XMLReader xmlReader = null;

    public CSSTranscodingHelper() {
        this((Transcoder)new PNGTranscoder());
    }

    public CSSTranscodingHelper(Transcoder trans) {
        this.transcoder = trans;
    }

    public void setDarkMode(boolean darkMode) {
        String pcs = darkMode ? "dark" : "light";
        this.transcoder.addTranscodingHint(SVGAbstractTranscoder.KEY_PREFERS_COLOR_SCHEME, (Object)pcs);
    }

    public void setHTMLEmbedding(boolean htmlEmbed) {
        this.htmlEmbed = htmlEmbed;
    }

    public Transcoder getTranscoder() {
        return this.transcoder;
    }

    public void setXMLReader(XMLReader xmlReader) {
        this.xmlReader = xmlReader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public void transcode(TranscoderInput input, TranscoderOutput output, String selector) throws TranscoderException, IOException {
        XMLReader oldXmlReader = this.xmlReader;
        XMLReader inpXmlReader = input.getXMLReader();
        if (inpXmlReader != null) {
            this.xmlReader = input.getXMLReader();
        }
        try {
            Document doc = input.getDocument();
            if (doc != null) {
                if (doc.getDocumentURI() == null) {
                    doc.setDocumentURI(input.getURI());
                }
                this.transcodeDocument(doc, output, selector);
                return;
            }
        }
        finally {
            if (inpXmlReader != null) {
                this.xmlReader = oldXmlReader;
            }
        }
        Reader reader = input.getReader();
        try {
            if (reader != null) {
                this.transcode(reader, input.getURI(), output, selector);
                return;
            }
        }
        finally {
            if (inpXmlReader != null) {
                this.xmlReader = oldXmlReader;
            }
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
            }
        }
        InputStream is = input.getInputStream();
        try {
            if (is != null) {
                InputStreamReader re = input.getEncoding() != null ? new InputStreamReader(is, input.getEncoding()) : new InputStreamReader(is);
                this.transcode(re, input.getURI(), output, selector);
                return;
            }
        }
        finally {
            if (inpXmlReader != null) {
                this.xmlReader = oldXmlReader;
            }
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
        }
        try {
            if (input.getURI() == null) {
                throw new IllegalArgumentException("No inputs found.");
            }
            this.transcode(null, input.getURI(), output, selector);
        }
        finally {
            if (inpXmlReader != null) {
                this.xmlReader = oldXmlReader;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void transcode(TranscoderInput input, TranscoderOutput output) throws TranscoderException, IOException {
        XMLReader oldXmlReader = this.xmlReader;
        XMLReader inpXmlReader = input.getXMLReader();
        if (inpXmlReader != null) {
            this.xmlReader = input.getXMLReader();
        }
        try {
            Document doc = input.getDocument();
            if (doc != null) {
                if (doc.getDocumentURI() == null) {
                    doc.setDocumentURI(input.getURI());
                }
                this.transcodeDocument(doc, output, null);
                return;
            }
            Reader reader = input.getReader();
            if (reader != null) {
                this.transcode(reader, input.getURI(), output, null);
                return;
            }
            InputStream is = input.getInputStream();
            if (is != null) {
                InputStreamReader re = input.getEncoding() != null ? new InputStreamReader(is, input.getEncoding()) : new InputStreamReader(is);
                this.transcode(re, input.getURI(), output, null);
                return;
            }
            if (input.getURI() == null) {
                throw new IllegalArgumentException("No inputs found.");
            }
            this.transcode(null, input.getURI(), output, null);
        }
        finally {
            if (inpXmlReader != null) {
                this.xmlReader = oldXmlReader;
            }
        }
    }

    public void transcode(Reader reader, String documentURI, OutputStream out) throws TranscoderException, IOException {
        TranscoderOutput output = new TranscoderOutput(out);
        this.transcode(reader, documentURI, output, null);
    }

    public void transcode(Reader reader, String documentURI, TranscoderOutput output, String selector) throws TranscoderException, IOException {
        DOMDocument document;
        CSSDOMImplementation impl = this.createCSSDOMImplementation();
        XMLDocumentBuilder builder = new XMLDocumentBuilder((DOMImplementation)impl);
        builder.setEntityResolver((EntityResolver)new DefaultEntityResolver());
        builder.getSAXParserFactory().setXIncludeAware(true);
        builder.setXMLReader(this.xmlReader);
        if (this.htmlEmbed || selector != null || documentURI != null && documentURI.endsWith(".html")) {
            builder.setHTMLProcessing(true);
        }
        InputSource source = new InputSource(reader);
        source.setSystemId(documentURI);
        try {
            document = (DOMDocument)builder.parse(source);
        }
        catch (SAXException e) {
            throw new TranscoderException((Exception)e);
        }
        this.transcodeDOMDocument(document, output, selector);
    }

    private CSSDOMImplementation createCSSDOMImplementation() {
        CSSDOMImplementation impl = new CSSDOMImplementation();
        impl.setStyleFormattingFactory(new StyleFormattingFactory(){
            private static final int COMP_MAX_FRACTION_DIGITS = 8;

            public StyleFormattingContext createStyleFormattingContext() {
                return new DefaultStyleFormattingContext();
            }

            public DeclarationFormattingContext createComputedStyleFormattingContext() {
                return new ColorDeclarationFormattingContext(){
                    private static final long serialVersionUID = 1L;

                    protected void writeColor(SimpleWriter wri, String propertyName, CSSColorValue value) throws IOException {
                        try {
                            this.serializeColor(wri, value);
                        }
                        catch (DOMException e) {
                            super.writeColor(wri, propertyName, value);
                        }
                    }

                    protected void writeColorMix(SimpleWriter wri, String propertyName, CSSColorMixFunction value) throws IOException {
                        try {
                            this.serializeColor(wri, (CSSColorValue)value);
                        }
                        catch (DOMException e) {
                            super.writeColorMix(wri, propertyName, value);
                        }
                        super.writeColorMix(wri, propertyName, value);
                    }

                    private void serializeColor(SimpleWriter wri, CSSColorValue value) throws DOMException, IOException {
                        CSSColor color = value.getColor();
                        if (color == null) {
                            throw new DOMException(15, "Color interpolation failed.");
                        }
                        if (color.isInGamut("srgb")) {
                            RGBAColor rgb = value.toRGBColor();
                            this.setComponentsMaximumFractionDigits((CSSColor)rgb, 8);
                            wri.write((CharSequence)rgb.toString());
                        } else {
                            String space = color.getColorSpace();
                            if (!"a98-rgb".equals(space)) {
                                space = !color.isInGamut("display-p3") && color.isInGamut("a98-rgb") ? "a98-rgb" : "display-p3";
                            }
                            CSSColor colorp = color.toColorSpace(space);
                            this.setComponentsMaximumFractionDigits(colorp, 8);
                            wri.write((CharSequence)colorp.toString());
                        }
                    }

                    private void setComponentsMaximumFractionDigits(CSSColor color, int maxFractionDigits) {
                        ((NumberValue)color.item(1)).setMaximumFractionDigits(maxFractionDigits);
                        ((NumberValue)color.item(2)).setMaximumFractionDigits(maxFractionDigits);
                        ((NumberValue)color.item(3)).setMaximumFractionDigits(maxFractionDigits);
                    }

                    protected void writeMinifiedColor(SimpleWriter wri, String propertyName, CSSColorValue value) throws IOException {
                        try {
                            this.serializeColorMinified(wri, value);
                        }
                        catch (DOMException e) {
                            super.writeMinifiedColor(wri, propertyName, value);
                        }
                    }

                    protected void writeMinifiedColorMix(SimpleWriter wri, String propertyName, CSSColorMixFunction value) throws IOException {
                        try {
                            this.serializeColorMinified(wri, (CSSColorValue)value);
                        }
                        catch (DOMException e) {
                            super.writeMinifiedColorMix(wri, propertyName, value);
                        }
                    }

                    private void serializeColorMinified(SimpleWriter wri, CSSColorValue value) throws DOMException, IOException {
                        CSSColor color = value.getColor();
                        if (color == null) {
                            throw new DOMException(15, "Color interpolation failed.");
                        }
                        if (color.isInGamut("srgb")) {
                            RGBAColor rgb = value.toRGBColor();
                            this.setComponentsMaximumFractionDigits((CSSColor)rgb, 8);
                            wri.write((CharSequence)rgb.toMinifiedString());
                        } else {
                            String space = color.getColorSpace();
                            if (!"a98-rgb".equals(space)) {
                                space = !color.isInGamut("display-p3") && color.isInGamut("a98-rgb") ? "a98-rgb" : "display-p3";
                            }
                            CSSColor colorp = color.toColorSpace(space);
                            this.setComponentsMaximumFractionDigits(colorp, 8);
                            wri.write((CharSequence)colorp.toMinifiedString());
                        }
                    }
                };
            }
        });
        return impl;
    }

    public void transcodeDocument(Document document, TranscoderOutput output, String selector) throws TranscoderException, IOException {
        DOMDocument cssDocument;
        if (document instanceof DOMDocument) {
            cssDocument = (DOMDocument)document;
        } else {
            String docTypeName;
            Element inputDocElm = document.getDocumentElement();
            if (inputDocElm == null) {
                throw new IllegalArgumentException("The document has no document element.");
            }
            DocumentType inputDocType = document.getDoctype();
            CSSDOMImplementation impl = this.createCSSDOMImplementation();
            DocumentType docType = null;
            if (inputDocType != null && (docTypeName = inputDocType.getName()) != null) {
                docType = impl.createDocumentType(docTypeName, inputDocType.getPublicId(), inputDocType.getSystemId());
            }
            cssDocument = this.isHTMLDocument(inputDocElm, inputDocType) ? impl.createDocument(null, null, docType) : impl.createDocument("", null, docType);
            cssDocument.setDocumentURI(document.getDocumentURI());
            Node docElm = cssDocument.importNode((Node)inputDocElm, true);
            cssDocument.appendChild(docElm);
        }
        this.transcodeDOMDocument(cssDocument, output, selector);
    }

    private boolean isHTMLDocument(Element docElm, DocumentType docType) {
        String tagName = docElm.getTagName();
        return "html".equalsIgnoreCase(tagName) || "html".equalsIgnoreCase(docElm.getLocalName()) || docType != null && "html".equalsIgnoreCase(docType.getName());
    }

    private void transcodeDOMDocument(DOMDocument document, TranscoderOutput output, String selector) throws TranscoderException, IOException {
        DocumentType docType = null;
        DOMElement svgRoot = null;
        if (selector == null) {
            selector = (String)this.transcoder.getTranscodingHints().get((Object)SVGAbstractTranscoder.KEY_SVG_SELECTOR);
        }
        if (selector != null && (selector = selector.trim()).length() != 0) {
            svgRoot = document.querySelector(selector);
        }
        if (svgRoot == null) {
            svgRoot = document.getDocumentElement();
            docType = document.getDoctype();
        }
        if (!"svg".equals(svgRoot.getLocalName())) {
            docType = null;
            if (selector == null) {
                svgRoot = document.getElementsByTagNameNS("*", "svg").item(0);
                if (svgRoot == null) {
                    String msg = "Document contains no <svg> elements.";
                    throw new TranscoderException(msg);
                }
            } else {
                selector = selector.replaceAll("\\p{Cc}", "*CTRL*");
                String msg = "Element selected by '" + selector + "' is not a <svg>.";
                throw new TranscoderException(msg);
            }
        }
        SizingHelper.defaultDimensions((Element)svgRoot);
        String version = svgRoot.getAttribute("version");
        boolean isSVG12 = version.length() == 0 ? docType == null || !"-//W3C//DTD SVG 1.0//EN".equals(docType.getPublicId()) : version.indexOf(50) != -1;
        DOMImplementation svgImpl = !isSVG12 ? SVGDOMImplementation.getDOMImplementation() : SVG12DOMImplementation.getDOMImplementation();
        DocumentType svgDocType = null;
        if (docType != null) {
            svgDocType = svgImpl.createDocumentType(docType.getName(), docType.getPublicId(), docType.getSystemId());
        }
        Document svgDoc = svgImpl.createDocument("http://www.w3.org/2000/svg", null, svgDocType);
        svgDoc.setDocumentURI(document.getDocumentURI());
        String alt = (String)this.transcoder.getTranscodingHints().get((Object)SVGAbstractTranscoder.KEY_ALTERNATE_STYLESHEET);
        String userSheetUri = (String)this.transcoder.getTranscodingHints().get((Object)SVGAbstractTranscoder.KEY_USER_STYLESHEET_URI);
        String medium = (String)this.transcoder.getTranscodingHints().get((Object)SVGAbstractTranscoder.KEY_MEDIA);
        if (medium == null || (medium = medium.trim()).length() == 0) {
            medium = "medium";
        }
        try {
            document.setTargetMedium(medium);
        }
        catch (CSSMediaException cSSMediaException) {
            // empty catch block
        }
        MyDeviceFactory devFactory = new MyDeviceFactory();
        devFactory.setHints(svgRoot);
        document.getImplementation().setDeviceFactory((DeviceFactory)devFactory);
        if (userSheetUri != null) {
            ParsedURL purl = new ParsedURL(userSheetUri);
            try (InputStream is = purl.openStream();){
                String conType = purl.getContentType();
                String conEnc = purl.getContentEncoding();
                Reader userRe = AgentUtil.inputStreamToReader((InputStream)is, (String)conType, (String)conEnc, (Charset)StandardCharsets.UTF_8);
                document.getImplementation().setUserStyleSheet(purl.getPostConnectionURL(), userRe);
            }
        }
        if (alt != null && (alt = alt.trim()).length() != 0) {
            document.setSelectedStyleSheetSet(alt);
        }
        CSSTranscodingHelper.copyWithComputedStyles((DOMNode)svgRoot, svgDoc, svgDoc);
        MyDeviceFactory.MyCanvas canvas = (MyDeviceFactory.MyCanvas)document.getCanvas();
        canvas.dispose();
        if (this.transcoder.getErrorHandler() == null) {
            DefaultErrorHandler handler = new DefaultErrorHandler();
            this.transcoder.setErrorHandler((ErrorHandler)handler);
        }
        TranscoderInput input = new TranscoderInput(svgDoc);
        this.transcoder.transcode(input, output);
        if (output.getDocument() == null) {
            output.setDocument(svgDoc);
        }
    }

    private static void copyWithComputedStyles(DOMNode node, Document svgDoc, Node svgParent) {
        Node svgNode;
        if (node.getNodeType() == 1) {
            if ("foreignObject".equals(node.getLocalName())) {
                DOMElement fo = (DOMElement)node;
                Element flowRoot = svgDoc.createElementNS("http://www.w3.org/2000/svg", "flowRoot");
                svgParent.appendChild(flowRoot);
                flowRoot.setAttributeNS("http://www.w3.org/XML/1998/namespace", "space", "preserve");
                CSSTranscodingHelper.replaceForeignSubtree(fo, svgDoc, flowRoot);
                return;
            }
            svgNode = CSSTranscodingHelper.importElement((DOMElement)node, svgDoc);
        } else {
            svgNode = svgDoc.importNode((Node)node, false);
        }
        svgParent.appendChild(svgNode);
        if (node.hasChildNodes()) {
            for (DOMNode n : node.getChildNodes()) {
                CSSTranscodingHelper.copyWithComputedStyles(n, svgDoc, svgNode);
            }
        }
    }

    private static Element importElement(DOMElement elm, Document svgDoc) {
        String name = elm.getLocalName();
        Element svgElm = (Element)svgDoc.importNode((Node)elm, false);
        if (!noStyle.contains(name)) {
            CSSTranscodingHelper.fillStyleAttribute(elm, svgElm);
        }
        return svgElm;
    }

    private static void fillStyleAttribute(DOMElement elm, Element svgElm) {
        ComputedCSSStyle style = elm.getComputedStyle(null);
        if (style.getLength() != 0) {
            svgElm.setAttribute("style", style.getMinifiedCssText());
        }
    }

    private static void replaceForeignSubtree(DOMElement fo, Document svgDoc, Element flowRoot) {
        if (fo.getChildElementCount() > 1) {
            return;
        }
        svgDoc.getDocumentElement().setAttribute("version", "1.2");
        Element flowDiv = svgDoc.createElementNS("http://www.w3.org/2000/svg", "flowDiv");
        Element flowRegion = svgDoc.createElementNS("http://www.w3.org/2000/svg", "flowRegion");
        flowRoot.appendChild(flowRegion);
        flowRoot.appendChild(flowDiv);
        DOMElement elm = fo.getFirstElementChild();
        if ("http://www.w3.org/2000/svg".equals(elm.getNamespaceURI())) {
            Element svgElm = CSSTranscodingHelper.importElement(elm, svgDoc);
            flowRoot.appendChild(svgElm);
        } else {
            boolean isBlock;
            ComputedCSSStyle style = elm.getComputedStyle(null);
            String display = style.getDisplay();
            boolean bl = isBlock = "block".equals(display) || "inline-block".equals(display);
            if (isBlock) {
                BoxValues box = style.getBoxValues((short)3);
                if ((double)box.getWidth() > 1.0E-4) {
                    box.fillBoxValues((CSSStyleDeclaration)style);
                }
                Element rect = svgDoc.createElementNS("http://www.w3.org/2000/svg", "rect");
                CSSTranscodingHelper.copyAttributes(fo, rect);
                rect.setAttribute("visibility", "hidden");
                flowRegion.appendChild(rect);
                rect.setAttribute("style", style.getMinifiedCssText());
                CSSTranscodingHelper.replaceElement(elm, svgDoc, flowDiv, flowDiv);
            }
        }
    }

    private static void copyAttributes(DOMElement fo, Element rect) {
        for (Attr attr : fo.getAttributes()) {
            rect.setAttributeNS(attr.getNamespaceURI(), attr.getName(), attr.getValue());
        }
    }

    private static void replaceElement(DOMElement elm, Document svgDoc, Element flowDiv, Element svgParent) {
        ComputedCSSStyle style = elm.getComputedStyle(null);
        String display = style.getDisplay();
        boolean isBlock = "block".equals(display) || "inline-block".equals(display);
        String elemName = isBlock ? "flowPara" : "flowSpan";
        Element flowElm = svgDoc.createElementNS("http://www.w3.org/2000/svg", elemName);
        if (style.getLength() != 0) {
            flowElm.setAttribute("style", style.getMinifiedCssText());
        }
        svgParent.appendChild(flowElm);
        if (elm.getFirstElementChild() == null) {
            String content = elm.getTextContent();
            String preserve = elm.getAttributeNS("http://www.w3.org/XML/1998/namespace", "space");
            if (!"preserve".equalsIgnoreCase(preserve)) {
                content = content.trim();
            }
            if (content.length() == 0) {
                return;
            }
            Text text = svgDoc.createTextNode(content);
            flowElm.appendChild(text);
        } else {
            for (DOMNode node : elm) {
                if (node.getNodeType() == 1) {
                    CSSTranscodingHelper.replaceElement((DOMElement)node, svgDoc, flowDiv, flowElm);
                    continue;
                }
                Text text = svgDoc.createTextNode(node.getNodeValue());
                flowElm.appendChild(text);
            }
        }
    }

    static {
        String[] noStArray = new String[]{"style", "script", "base", "link", "head", "title", "meta"};
        noStyle = new HashSet<String>(noStArray.length);
        Collections.addAll(noStyle, noStArray);
        darkmodeInitialColor = (CSSTypedValue)new ValueFactory().parseProperty("#fff");
    }

    private class MyDeviceFactory
    implements DeviceFactory {
        private MyStyleDatabase sdb = new MyStyleDatabase();
        private float height = 0.0f;
        private float width = 0.0f;

        private MyDeviceFactory() {
        }

        public StyleDatabase getStyleDatabase(String medium) {
            return this.sdb;
        }

        void setHints(DOMElement svgRoot) {
            TranscodingHints transcodingHints = CSSTranscodingHelper.this.getTranscoder().getTranscodingHints();
            Float width = (Float)transcodingHints.get((Object)SVGAbstractTranscoder.KEY_WIDTH);
            if (width != null) {
                this.width = width.floatValue();
            } else {
                String w = svgRoot.getAttribute("width");
                if (w.length() != 0) {
                    try {
                        this.width = Float.parseFloat(w);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                if (this.width == 0.0f) {
                    this.width = 595.0f;
                }
            }
            Float height = (Float)transcodingHints.get((Object)SVGAbstractTranscoder.KEY_HEIGHT);
            if (height != null) {
                this.height = height.floatValue();
            } else {
                String h = svgRoot.getAttribute("height");
                if (h.length() != 0) {
                    try {
                        this.height = Float.parseFloat(h);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                if (this.height == 0.0f) {
                    this.height = 842.0f;
                }
            }
        }

        public CSSCanvas createCanvas(String medium, CSSDocument doc) {
            MyCanvas canvas;
            if (CSSTranscodingHelper.this.transcoder instanceof ImageTranscoder) {
                BufferedImage dest = ((ImageTranscoder)CSSTranscodingHelper.this.transcoder).createImage(Math.round(this.width), Math.round(this.height));
                Graphics2D graphics2d = dest.createGraphics();
                canvas = new Graphics2DCanvas(doc, graphics2d);
            } else {
                canvas = new MyCanvas(doc);
            }
            return canvas;
        }

        private class MyStyleDatabase
        extends AbstractStyleDatabase {
            private static final long serialVersionUID = 1L;
            private final List<String> fonts = this.getAvailableFontList();

            private MyStyleDatabase() {
            }

            private List<String> getAvailableFontList() {
                return Arrays.asList(GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames());
            }

            public String getDefaultGenericFontFamily(String genericFamily) {
                return genericFamily;
            }

            public boolean isFontFaceName(String requestedFamily) {
                return false;
            }

            public int getColorDepth() {
                GraphicsEnvironment genv = GraphicsEnvironment.getLocalGraphicsEnvironment();
                GraphicsConfiguration gConfiguration = genv.getDefaultScreenDevice().getDefaultConfiguration();
                int bpc = 255;
                if (gConfiguration != null) {
                    int[] comp = gConfiguration.getColorModel().getComponentSize();
                    for (int i = 0; i < 3; ++i) {
                        if (bpc <= comp[i]) continue;
                        bpc = comp[i];
                    }
                }
                return bpc;
            }

            public float getDeviceHeight() {
                return MyDeviceFactory.this.height;
            }

            public float getDeviceWidth() {
                return MyDeviceFactory.this.width;
            }

            protected boolean isFontFamilyAvailable(String fontFamily) {
                return this.fonts.contains(fontFamily);
            }

            public CSSTypedValue getInitialColor() {
                boolean darkMode = "dark".equalsIgnoreCase((String)CSSTranscodingHelper.this.transcoder.getTranscodingHints().get((Object)SVGAbstractTranscoder.KEY_PREFERS_COLOR_SCHEME));
                return darkMode ? darkmodeInitialColor : super.getInitialColor();
            }

            public boolean supports(String property, LexicalUnit lunit) {
                ValueFactory valueFactory = new ValueFactory();
                StyleValue value = valueFactory.createCSSValue(lunit);
                if ("color".equalsIgnoreCase(property) || "background-color".equalsIgnoreCase(property)) {
                    return this.supportsColor((CSSValue)value);
                }
                return value.getCssValueType() == CSSValue.CssType.TYPED && this.isSupportedType((CSSTypedValue)value);
            }

            private boolean supportsColor(CSSValue value) {
                switch (value.getPrimitiveType()) {
                    case COLOR: 
                    case COLOR_MIX: {
                        return true;
                    }
                    case IDENT: {
                        return ColorIdentifiers.getInstance().isColorIdentifier(value.getCssText().toLowerCase(Locale.ROOT));
                    }
                }
                return false;
            }

            private boolean isSupportedType(CSSTypedValue value) {
                short unit = value.getUnitType();
                return unit >= 3 && unit <= 21 || CSSUnit.isAngleUnitType((short)unit) || CSSUnit.isTimeUnitType((short)unit);
            }

            public boolean supports(SelectorList selectors) {
                for (Selector selector : selectors) {
                    if (this.supports(selector)) continue;
                    return false;
                }
                return true;
            }

            private boolean supports(Selector selector) {
                if (selector != null) {
                    switch (selector.getSelectorType()) {
                        case CHILD: 
                        case DESCENDANT: 
                        case DIRECT_ADJACENT: 
                        case SUBSEQUENT_SIBLING: {
                            CombinatorSelector combSel = (CombinatorSelector)selector;
                            return this.supports(combSel.getSelector()) && this.supports((Selector)combSel.getSecondSelector());
                        }
                        case CONDITIONAL: {
                            ConditionalSelector condSel = (ConditionalSelector)selector;
                            return this.supports((Selector)condSel.getSimpleSelector()) && this.supports(condSel.getCondition());
                        }
                        case COLUMN_COMBINATOR: {
                            return false;
                        }
                    }
                }
                return true;
            }

            private boolean supports(Condition condition) {
                switch (condition.getConditionType()) {
                    case AND: {
                        CombinatorCondition combCond = (CombinatorCondition)condition;
                        return this.supports(combCond.getFirstCondition()) && this.supports(combCond.getSecondCondition());
                    }
                    case SELECTOR_ARGUMENT: {
                        ArgumentCondition argCond = (ArgumentCondition)condition;
                        SelectorList selist = argCond.getSelectors();
                        return selist == null || this.supports(selist);
                    }
                    case PSEUDO_CLASS: 
                    case PSEUDO_ELEMENT: {
                        break;
                    }
                    default: {
                        return true;
                    }
                }
                return false;
            }
        }

        private class Graphics2DCanvas
        extends MyCanvas {
            final Graphics2D graphics2d;

            protected Graphics2DCanvas(CSSDocument doc, Graphics2D graphics2d) {
                super(doc);
                this.graphics2d = graphics2d;
            }

            public int stringWidth(String text, CSSComputedProperties style) {
                Font font = AWTHelper.createFont((CSSComputedProperties)style);
                FontMetrics fm = this.graphics2d.getFontMetrics(font);
                return fm.stringWidth(text);
            }

            @Override
            void dispose() {
                this.graphics2d.dispose();
            }
        }

        private class MyCanvas
        extends AbstractCSSCanvas {
            private CSSDocument document;

            protected MyCanvas(CSSDocument doc) {
                this.document = doc;
            }

            public CSSDocument getDocument() {
                return this.document;
            }

            public StyleDatabase getStyleDatabase() {
                return MyDeviceFactory.this.sdb;
            }

            protected String getOverflowBlock() {
                return "none";
            }

            protected String getOverflowInline() {
                return "none";
            }

            protected String getPointerAccuracy() {
                return "none";
            }

            protected String getPrefersColorScheme() {
                String pcs;
                String defPcs = "light";
                try {
                    pcs = (String)CSSTranscodingHelper.this.transcoder.getTranscodingHints().getOrDefault((Object)SVGAbstractTranscoder.KEY_PREFERS_COLOR_SCHEME, (Object)"light");
                }
                catch (ClassCastException e) {
                    pcs = "light";
                }
                return pcs;
            }

            protected float getResolution() {
                return Float.POSITIVE_INFINITY;
            }

            void dispose() {
            }
        }
    }
}

