/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.transcoder;

import io.sf.carte.echosvg.anim.dom.SVGDOMImplementation;
import io.sf.carte.echosvg.dom.GenericDOMImplementation;
import io.sf.carte.echosvg.dom.util.DocumentFactory;
import io.sf.carte.echosvg.dom.util.SAXDocumentFactory;
import io.sf.carte.echosvg.transcoder.AbstractTranscoder;
import io.sf.carte.echosvg.transcoder.TranscoderException;
import io.sf.carte.echosvg.transcoder.TranscoderInput;
import io.sf.carte.echosvg.transcoder.TranscoderOutput;
import io.sf.carte.echosvg.transcoder.TranscodingHints;
import io.sf.carte.echosvg.transcoder.keys.BooleanKey;
import io.sf.carte.echosvg.transcoder.keys.DOMImplementationKey;
import io.sf.carte.echosvg.transcoder.keys.StringKey;
import java.io.IOException;
import org.w3c.dom.DOMException;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;

public abstract class XMLAbstractTranscoder
extends AbstractTranscoder {
    public static final TranscodingHints.Key KEY_XML_PARSER_VALIDATING = new BooleanKey();
    public static final TranscodingHints.Key KEY_DOCUMENT_ELEMENT = new StringKey();
    public static final TranscodingHints.Key KEY_DOCUMENT_ELEMENT_NAMESPACE_URI = new StringKey();
    public static final TranscodingHints.Key KEY_DOM_IMPLEMENTATION = new DOMImplementationKey();

    protected XMLAbstractTranscoder() {
        this.hints.put(KEY_XML_PARSER_VALIDATING, (Object)Boolean.FALSE);
    }

    @Override
    public void transcode(TranscoderInput input, TranscoderOutput output) throws TranscoderException {
        Document document = null;
        document = input.getDocument() != null ? input.getDocument() : this.loadDocument(input);
        if (document != null) {
            String uri = input.getURI();
            try {
                this.transcode(document, uri, output);
            }
            catch (TranscoderException ex) {
                this.handler.fatalError(ex);
                return;
            }
        }
    }

    private Document loadDocument(TranscoderInput input) throws TranscoderException {
        String namespaceURI = (String)this.hints.get(KEY_DOCUMENT_ELEMENT_NAMESPACE_URI);
        String documentElement = (String)this.hints.get(KEY_DOCUMENT_ELEMENT);
        DocumentFactory f = this.createDocumentFactory(documentElement);
        if (namespaceURI == null) {
            this.handler.fatalError(new TranscoderException("Unspecified transcoding hints: KEY_DOCUMENT_ELEMENT_NAMESPACE_URI"));
            return null;
        }
        if (documentElement == null) {
            this.handler.fatalError(new TranscoderException("Unspecified transcoding hints: KEY_DOCUMENT_ELEMENT"));
            return null;
        }
        Object xmlParserValidating = this.hints.get(KEY_XML_PARSER_VALIDATING);
        boolean validating = xmlParserValidating != null && (Boolean)xmlParserValidating != false;
        f.setValidating(validating);
        f.setXMLReader(input.getXMLReader());
        String uri = input.getURI();
        Document document = null;
        try {
            if (input.getInputStream() != null) {
                document = f.createDocument(namespaceURI, documentElement, uri, input.getInputStream(), input.getEncoding());
            } else if (input.getReader() != null) {
                document = f.createDocument(namespaceURI, documentElement, uri, input.getReader());
            } else if (uri != null) {
                document = f.createDocument(namespaceURI, documentElement, uri, input.getEncoding());
            }
        }
        catch (DOMException ex) {
            this.handler.fatalError(new TranscoderException(ex));
        }
        catch (IOException ex) {
            this.handler.fatalError(new TranscoderException(ex));
        }
        return document;
    }

    private DocumentFactory createDocumentFactory(String documentElement) {
        DocumentFactory f;
        DOMImplementation domImpl = (DOMImplementation)this.hints.get(KEY_DOM_IMPLEMENTATION);
        if (domImpl == null) {
            if ("html".equalsIgnoreCase(documentElement)) {
                domImpl = GenericDOMImplementation.getDOMImplementation();
                f = new SAXDocumentFactory(domImpl);
            } else {
                domImpl = SVGDOMImplementation.getDOMImplementation();
                f = this.createDocumentFactory(domImpl);
            }
        } else {
            f = this.createDocumentFactory(domImpl);
        }
        return f;
    }

    protected DocumentFactory createDocumentFactory(DOMImplementation domImpl) {
        return new SAXDocumentFactory(domImpl);
    }

    protected abstract void transcode(Document var1, String var2, TranscoderOutput var3) throws TranscoderException;
}

