/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.transcoder.image;

import io.sf.carte.echosvg.ext.awt.image.codec.png.PNGEncodeParam;
import io.sf.carte.echosvg.ext.awt.image.codec.png.PNGImageEncoder;
import io.sf.carte.echosvg.ext.awt.image.rendered.IndexImage;
import io.sf.carte.echosvg.transcoder.TranscoderException;
import io.sf.carte.echosvg.transcoder.TranscoderOutput;
import io.sf.carte.echosvg.transcoder.TranscodingHints;
import io.sf.carte.echosvg.transcoder.image.PNGTranscoder;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.OutputStream;

class PNGTranscoderInternalCodecWriteAdapter
implements PNGTranscoder.WriteAdapter {
    PNGTranscoderInternalCodecWriteAdapter() {
    }

    @Override
    public void writeImage(PNGTranscoder transcoder, BufferedImage img, TranscoderOutput output) throws TranscoderException {
        String[] text;
        PNGEncodeParam params;
        TranscodingHints hints = transcoder.getTranscodingHints();
        int n = -1;
        if (hints.containsKey(PNGTranscoder.KEY_INDEXED) && ((n = ((Integer)hints.get(PNGTranscoder.KEY_INDEXED)).intValue()) == 1 || n == 2 || n == 4 || n == 8)) {
            img = IndexImage.getIndexedImage((BufferedImage)img, (int)(1 << n));
        }
        if ((params = PNGEncodeParam.getDefaultEncodeParam((RenderedImage)img)) instanceof PNGEncodeParam.RGB) {
            ((PNGEncodeParam.RGB)params).setBackgroundRGB(new int[]{255, 255, 255});
        }
        if (hints.containsKey(PNGTranscoder.KEY_GAMMA)) {
            float gamma = ((Float)hints.get(PNGTranscoder.KEY_GAMMA)).floatValue();
            if (gamma > 0.0f) {
                params.setGamma(gamma);
            }
            params.setChromaticity(PNGTranscoder.DEFAULT_CHROMA);
        } else {
            params.setSRGBIntent(0);
        }
        Integer level = (Integer)hints.get(PNGTranscoder.KEY_COMPRESSION_LEVEL);
        if (level != null) {
            params.setCompressionLevel(level.intValue());
        }
        if ((text = (String[])hints.get(PNGTranscoder.KEY_KEYWORD_TEXT)) != null) {
            params.setText(text);
        }
        if ((text = (String[])hints.get(PNGTranscoder.KEY_INTERNATIONAL_TEXT)) != null) {
            params.setInternationalText(text);
        }
        if ((text = (String[])hints.get(PNGTranscoder.KEY_COMPRESSED_TEXT)) != null) {
            params.setCompressedText(text);
        }
        float PixSzMM = transcoder.getUserAgent().getPixelUnitToMillimeter();
        int numPix = (int)((double)(1000.0f / PixSzMM) + 0.5);
        params.setPhysicalDimension(numPix, numPix, 1);
        try {
            OutputStream ostream = output.getOutputStream();
            PNGImageEncoder pngEncoder = new PNGImageEncoder(ostream, params);
            pngEncoder.encode((RenderedImage)img);
            ostream.flush();
        }
        catch (IOException ex) {
            throw new TranscoderException(ex);
        }
    }
}

