/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.transcoder.image;

import io.sf.carte.echosvg.transcoder.TranscoderException;
import io.sf.carte.echosvg.transcoder.TranscoderOutput;
import io.sf.carte.echosvg.transcoder.TranscodingHints;
import io.sf.carte.echosvg.transcoder.image.ImageTranscoder;
import io.sf.carte.echosvg.transcoder.image.TIFFTranscoderImageIOWriteAdapter;
import io.sf.carte.echosvg.transcoder.keys.StringKey;
import java.awt.image.BufferedImage;
import java.awt.image.SinglePixelPackedSampleModel;

public class TIFFTranscoder
extends ImageTranscoder {
    public static final TranscodingHints.Key KEY_FORCE_TRANSPARENT_WHITE = ImageTranscoder.KEY_FORCE_TRANSPARENT_WHITE;
    public static final TranscodingHints.Key KEY_COMPRESSION_METHOD = new StringKey();

    public TIFFTranscoder() {
        this.hints.put(KEY_FORCE_TRANSPARENT_WHITE, (Object)Boolean.FALSE);
    }

    @Override
    public BufferedImage createImage(int width, int height) {
        return new BufferedImage(width, height, 2);
    }

    @Override
    public void writeImage(BufferedImage img, TranscoderOutput output) throws TranscoderException {
        boolean forceTransparentWhite = false;
        if (this.hints.containsKey(ImageTranscoder.KEY_FORCE_TRANSPARENT_WHITE)) {
            forceTransparentWhite = (Boolean)this.hints.get(ImageTranscoder.KEY_FORCE_TRANSPARENT_WHITE);
        }
        if (forceTransparentWhite) {
            SinglePixelPackedSampleModel sppsm = (SinglePixelPackedSampleModel)img.getSampleModel();
            this.forceTransparentWhite(img, sppsm);
        }
        TIFFTranscoderImageIOWriteAdapter adapter = new TIFFTranscoderImageIOWriteAdapter();
        adapter.writeImage(this, img, output);
    }

    public static interface WriteAdapter {
        public void writeImage(TIFFTranscoder var1, BufferedImage var2, TranscoderOutput var3) throws TranscoderException;
    }
}

